/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#include "search.h"

#include <tdeconfig.h>

KCMKerrySearch::KCMKerrySearch(TQWidget *parent, const char * )
    : TDECModule(parent, "kcmkerrysearch")
{
    TQVBoxLayout* top_layout = new TQVBoxLayout( this, KDialog::spacingHint() );

    // General
    TQGroupBox* gb_general = new TQGroupBox(0, Qt::Vertical, i18n("General"), this);
    gb_general->setFlat(true);
    top_layout->addWidget(gb_general);
    TQVBoxLayout* gb_general_layout = new TQVBoxLayout( gb_general->layout(), KDialog::spacingHint() );

    TQHBoxLayout* qh_layout = new TQHBoxLayout(gb_general_layout);
    TQLabel* label_order = new TQLabel(i18n("Default result sort order:"), gb_general);
    qh_layout->addWidget(label_order);
    combo_order = new TQComboBox(gb_general);
    combo_order->insertItem(i18n("Type"));
    combo_order->insertItem(i18n("Date Modified"));
    combo_order->insertItem(i18n("Name"));
    combo_order->insertItem(i18n("Relevance"));
    TQWhatsThis::add(combo_order,i18n("Define the default sort order at startup."));
    label_order->setBuddy(combo_order);
    qh_layout->addWidget(combo_order);

    TQHBoxLayout* qh_number = new TQHBoxLayout(gb_general_layout);
    TQLabel* label_number = new TQLabel(i18n( "Maximum number of results displayed:" ), gb_general);
    qh_number->addWidget(label_number);
    maxResultsDisplayed = new TQSpinBox( 1, 100, 1, gb_general );
    maxResultsDisplayed->setSpecialValueText(i18n("No Limit"));
    TQWhatsThis::add(maxResultsDisplayed,i18n("Define how many results shall be displayed on one result page."));
    label_number->setBuddy(maxResultsDisplayed);
    qh_number->addWidget(maxResultsDisplayed);

    showBigTiles = new TQCheckBox(i18n("Show search results with details by default"), gb_general);
    gb_general_layout->addWidget(showBigTiles);

    // Global Shortcuts
    TQGroupBox* gb_keys = new TQGroupBox(0, Qt::Vertical, i18n("Global Shortcuts"), this);
    TQVBoxLayout* gb_keys_layout = new TQVBoxLayout( gb_keys->layout(), KDialog::spacingHint() );
    top_layout->addWidget(gb_keys);
    gb_keys->setFlat(true);

    globalKeys = new TDEGlobalAccel(TQT_TQOBJECT(this));
    globalKeys->insert( "Program:kerry", i18n("Kerry Beagle Search") );

    TDEShortcut showDialogShortcut = TDEShortcut(ALT+Key_Space);
    showDialogShortcut.append( KKey( Key_F12 ) );
    globalKeys->insert( "Show Kerry Dialog", i18n("Show Search Dialog"), TQString(), showDialogShortcut, showDialogShortcut, 0, 0);
    globalKeys->insert( "Search Primary Selection with Kerry", i18n("Search Primary Selection"), TQString(), CTRL+ALT+Key_Space, CTRL+ALT+Key_Space, 0, 0);

    TDEConfig *config = new TDEConfig("kerryrc");
    globalKeys->readSettings(config);
    delete config;

    keysWidget = new KKeyChooser( globalKeys, gb_keys );
    gb_keys_layout->addWidget(keysWidget);

    // Add some spacing at the end
    TQWidget *dummy = new TQWidget( this );
    top_layout->setStretchFactor( dummy, 1 );
    top_layout->addWidget(dummy);

    connect(maxResultsDisplayed, TQT_SIGNAL(valueChanged(int)), TQT_SLOT(changedValue()));
    connect(combo_order, TQT_SIGNAL(activated(int)), TQT_SLOT(changedValue()));
    connect(keysWidget, TQT_SIGNAL(keyChange()), TQT_SLOT(changedValue()));
    connect(showBigTiles, TQT_SIGNAL(clicked()), TQT_SLOT(changedValue()));

    load();
}

KCMKerrySearch::~KCMKerrySearch()
{
}

void KCMKerrySearch::changedValue()
{
    emit changed( true );
}

void KCMKerrySearch::load()
{
    load( false );
}

void KCMKerrySearch::load( bool useDefaults )
{
    if (useDefaults) {
       maxResultsDisplayed->setValue(20);
       combo_order->setCurrentItem(0);
       keysWidget->allDefault();
       showBigTiles->setChecked(false);
    }
    else {
       TDEConfig *config = new TDEConfig("kerryrc");
       config->setGroup("General");
       maxResultsDisplayed->setValue(config->readNumEntry("DisplayAmount", 20));
       combo_order->setCurrentItem(config->readNumEntry("DefaultSortOrder",0));
       showBigTiles->setChecked(config->readBoolEntry("ShowBigTiles",false));
       delete config;
    }

    emit changed( useDefaults );
}

void KCMKerrySearch::defaults()
{
     load( true );
}

void KCMKerrySearch::save()
{
    TDEConfig *config = new TDEConfig("kerryrc");
    config->setGroup("General");
    config->writeEntry("DisplayAmount", maxResultsDisplayed->value());
    config->writeEntry("DefaultSortOrder", combo_order->currentItem());
    config->writeEntry("ShowBigTiles", showBigTiles->isChecked());

    keysWidget->commitChanges();
    globalKeys->writeSettings(config);

    config->sync();
    delete config;

}

#include "search.moc"
