/*****************************************************************

   Copyright (c) 2006 Stephan Binner <binner@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

******************************************************************/

#ifndef __BACKENDS_H__
#define __BACKENDS_H__

#include <tdecmodule.h>
#include <kdebug.h>
#include <tdelistview.h>
#include <kprocess.h>

class KCMBeagleBackends : public TDECModule
{
  Q_OBJECT
  

public:
  KCMBeagleBackends(TQWidget *parent=0, const char *name=0);
  ~KCMBeagleBackends();

  virtual void load();
  virtual void load( bool useDefaults );
  virtual void save();
  virtual void defaults();

protected slots:
  void gotAvailableBackends(TDEProcess*, char *buffer, int len);
  void changedValue();

private:
  TDEListView* listview;

  TQStringList readDisabledBackends();
  bool saveDisabledBackends(TQStringList disabledBackends);
};

#endif
