/*
 * kdpg.h
 *
 * Copyright (c) 2007 Fabian Wuertz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INSTALL_H_
#define INSTALL_H_

#include <installdialog.h>

#include <kde_terminal_interface.h>
#include <tdeparts/part.h>
#include <process.h>
#include <tqprocess.h>

class install : public InstallDialog
{
	Q_OBJECT
  

	public:
		install(const TQString &url = TQString(), TQWidget *parent = 0L, const char *name = 0L, const TQStringList &foo = TQStringList());
		TQString installPkg;
		TQString removePkg;
		TQString path;
		TQStringList fields;
		TQString m_kdePrefix;
		bool isInstalled(TQString);
		bool checkArchitecture();
		bool isLocked();
		TQStringList getVersions(TQString);



	private:
		Process* shell;


	public slots:
		virtual void showAbout();
		virtual void page1();
		virtual void page2x1();
		virtual void page2x2();
		virtual void page3();
		virtual void page4();
		virtual void page5();
		virtual void showDependencies();
		virtual void next1();
		virtual void next2();

	signals:
		void exit(bool);

};

#endif
