/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef ProcAttach_included
#define ProcAttach_included

#include "procattachbase.h"
#include <ntqvaluevector.h>
#include <ntqdialog.h>
#include <ntqlabel.h>
#include <ntqlineedit.h>
#include <ntqpushbutton.h>
#include <ntqlayout.h>


class TDEProcess;

/*
 * This is the full-featured version of the dialog. It is used when the
 * system features a suitable ps command.
 */

class ProcAttachPS : public ProcAttachBase
{
    Q_OBJECT
public:
    ProcAttachPS(TQWidget* parent);
    ~ProcAttachPS();

    TQString text() const;

protected:
    void runPS();
    virtual void refresh();
    virtual void filterEdited(const TQString& text);
    virtual void selectedChanged();

protected slots:
    void slotTextReceived(TDEProcess* proc, char* buffer, int buflen);
    void slotPSDone();

protected:
    void pushLine();
    bool setVisibility(TQListViewItem* i, const TQString& text);

    TDEProcess* m_ps;
    // parse state
    int m_pidCol;	//!< The PID column in the ps output
    int m_ppidCol;	//!< The parent-PID column in the ps output
    TQCString m_token;
    TQValueVector<TQString> m_line;
};


/*
 * This is an extremely stripped down version of the dialog. It is used
 * when there is no suitable ps command.
 */

class ProcAttach : public TQDialog
{
public:
    ProcAttach(TQWidget* parent);
    virtual ~ProcAttach();

    void setText(const TQString& text) { m_processId.setText(text); }
    TQString text() const { return m_processId.text(); }

protected:
    TQLabel m_label;
    TQLineEdit m_processId;
    TQPushButton m_buttonOK;
    TQPushButton m_buttonCancel;
    TQVBoxLayout m_layout;
    TQHBoxLayout m_buttons;
};

#endif // ProcAttach_included
