/***************************************************************************
 *   Copyright (C) 2007 by Albert Astals Cid, aacid@kde.org                *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef INCLUDE_QT34_H
#define INCLUDE_QT34_H

#include <tqregexp.h>
#include <tqstring.h>

// TQt3/TQt4 compatibility: in TQt3 TQVector stores pointers, not values - so TQValueVector should be used. 
// In TQt4 TQVector stores values, so we can use TQVector
#if defined (USE_TQT_4)
	#define	LIBCHMVector	TQVector
#else
#include <tqvaluevector.h>
	#define	LIBCHMVector	TQValueVector
#endif

#if defined (USE_TQT_4)
	#define	LIBCHMMemArray	TQVector
#else
	#define	LIBCHMMemArray	TQMemArray
#endif

class LIBCHMCString
{
	public:
		LIBCHMCString();
		LIBCHMCString(const char *string);
		
		const char *toCString() const;
		
		void clear();
		
		bool operator==(const TQString &string) const;
		uint length() const;
		bool isEmpty() const;
		void prepend(char c);
		char at(uint i) const;
		void replace(uint index, uint len, const char *str);
		void remove(uint index, uint len);
		LIBCHMCString lower();
	
	private:
#if defined (USE_TQT_4)
		TQByteArray cs;
#else
		TQCString cs;
#endif
};

class LIBCHMRegExp
{
	public:
		LIBCHMRegExp(const TQString &regexp);
		
		int search(const TQString &str, int offset = 0);
		TQString cap(int nth);
		void setMinimal(bool minimal);
		int matchedLength() const;
	
	private:
		TQRegExp re;
};

class LIBCHMString
{
	public:
		LIBCHMString();
		LIBCHMString(const TQString &string);
		LIBCHMString(const char *string);
		
		TQString lower() const;
		const char *ascii() const;
		int find(char c, int index = -1) const;
		int find(const TQChar &c, int index) const;
		int find(const TQString &string, int index, bool cs) const;
		int findRev(char c) const;
		TQChar at(uint i) const;
		TQString left(uint len) const;
		LIBCHMString mid(uint index, uint len = 0xffffffff) const;
		bool isEmpty() const;
		
		TQString toString() const;
		
		bool operator==(const TQString &string) const;
	
	private:
		TQString s;
};

class LIBCHMDir
{
	public:
		static TQString cleanDirPath(const TQString &dir);
};

class LIBCHMStringList
{
	public:
		static bool contains(const TQStringList &list, const TQString &string);
		static TQStringList split(const TQRegExp &regexp, const TQString &string);
};

#endif
