//
// C++ Implementation: kbfileinfo
//
// Description: 
//
//
// Author: Magnus Kulke <mkulke@magnusmachine>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//

// enable > 2gb support (LFS)

#define _LARGEFILE_SOURCE
#define _LARGEFILE64_SOURCE 

#include <tqregexp.h>
#include <tqdir.h>

#include "kbconfig.h"
#include "kbitem.h"

#include "kbfileinfo.h"

/*KbFileInfo::KbFileInfo() : TQFileInfo()
{

}*/

KbFileInfo::KbFileInfo(TQString workingdir) : TQFileInfo(TQDir(workingdir), ".")
{

}

bool KbFileInfo::PrioritySort(KbFileInfo *f1, KbFileInfo *f2)
//bool KbFileInfo::PrioritySort(const KbFileInfo &f1, const KbFileInfo &f2)
{
	TQRegExp m_prioritylist(KbConfig::prioritylist());

	if ((m_prioritylist.search(f1->fileName()) >= 0) > (m_prioritylist.search(f2->fileName()) >= 0)) return true;
	else return false;
};

KbFileInfo::KbFileInfo(TQFileInfo qfi) : TQFileInfo(qfi)
{
	m_date_int = 
		qfi.lastModified().date().year() * 10000 +
		qfi.lastModified().date().month() * 100 +
		qfi.lastModified().date().day();
	m_date = qfi.lastModified().toString("MMM dd yyyy");
	m_size = qfi.size();
}

KbFileInfo::KbFileInfo(const KbFileInfo& kfi) : TQFileInfo(kfi)
{
	m_date_int = kfi.m_date_int;
	m_date = kfi.m_date;
	m_size = kfi.m_size;
}

KbFileInfo::KbFileInfo(KbItem* item, TQString workingdir) : TQFileInfo(TQDir(workingdir), item->File())
{
	m_date_int = item->DateInt();
	m_date = item->Date();
	m_size = item->Size();
}

KbFileInfo::KbFileInfo(const TQString & d, const TQString & fileName, off64_t size, TQString date, unsigned int date_int)
 : TQFileInfo(TQDir(d), fileName)
{
	m_date_int = date_int;
	m_date = date;
	m_size = size;
}

KbFileInfo::~KbFileInfo()
{
}

void KbFileInfo::SetDirPath(TQString path)
{
	setFile(TQDir(path), fileName());
} 

