// vim: set tabstop=4 shiftwidth=4 noexpandtab
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�lien G�teau
 
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 
*/
// KDE
#include <tdelocale.h>

// Local
#include "document.h"
#include "documentimpl.moc"
namespace Gwenview {

DocumentImpl::DocumentImpl(Document* document)
: mDocument(document) {}

void DocumentImpl::init() {}

DocumentImpl::~DocumentImpl() {}

void DocumentImpl::switchToImpl(DocumentImpl* impl) {
	mDocument->switchToImpl(impl);
}

void DocumentImpl::setImage(TQImage img) {
	if (img.depth() == 1) {
		// 1 bit depth images are difficult to scale. Let's convert to 8 bit
		// depth. See bug #155518.
		img = img.convertDepth(8);
	}
	mDocument->setImage(img);
}

void DocumentImpl::emitImageRectUpdated() {
	emit rectUpdated(mDocument->image().rect());
}

void DocumentImpl::setImageFormat(const TQCString& format) {
	mDocument->setImageFormat(format);
}

void DocumentImpl::setMimeType(const TQString& mimeType) {
	mDocument->setMimeType(mimeType);
}

void DocumentImpl::setFileSize(int size) const {
	mDocument->setFileSize(size);
}

TQString DocumentImpl::aperture() const {
	return TQString();
}

TQString DocumentImpl::exposureTime() const {
	return TQString();
}

TQString DocumentImpl::iso() const {
	return TQString();
}

TQString DocumentImpl::focalLength() const {
	return TQString();
}

TQString DocumentImpl::comment() const {
	return TQString();
}

Document::CommentState DocumentImpl::commentState() const {
	return Document::NONE;
}

void DocumentImpl::setComment(const TQString&) {
}

int DocumentImpl::duration() const {
	return 0;
}

void DocumentImpl::transform(ImageUtils::Orientation) {
}

TQString DocumentImpl::save(const KURL&, const TQCString&) const {
	return i18n("No document to save");
}

} // namespace
