// vim: set tabstop=4 shiftwidth=4 noexpandtab:
/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�ien G�eau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef TRUNCATEDTEXTLABEL_H
#define TRUNCATEDTEXTLABEL_H   

// TQt
#include <tqlabel.h>
#include <tqtooltip.h>

// KDE
#include <kwordwrap.h>

namespace Gwenview {

/**
 * A label which truncates it's text if it's too long, drawing it using
 * KWordWrap::drawFadeoutText()
 */
class TruncatedTextLabel : public TQLabel {
public:
	TruncatedTextLabel(TQWidget* parent)
	: TQLabel(parent) {}

	TQSize minimumSizeHint() const {
		TQSize size=TQLabel::minimumSizeHint();
		size.setWidth(-1);
		return size;
	}

	TQSize sizeHint() const {
		return TQSize(contentsRect().width(), TQLabel::sizeHint().height());
	}

	void setText(const TQString& text) {
		TQLabel::setText(text);
		updateToolTip();
	}

protected:
	void drawContents(TQPainter* painter) {
		KWordWrap::drawFadeoutText(painter, 0, fontMetrics().ascent(), width(), text());
	}

	void resizeEvent(TQResizeEvent*) {
		updateToolTip();
	}

	void updateToolTip() {
		TQString txt=text();
		TQToolTip::remove(this);
		if ( width() < fontMetrics().width(txt) ) {
			TQToolTip::add(this, txt);
		} else {
			TQToolTip::hide();
		}
	}
};

} // namespace

#endif /* TRUNCATEDTEXTLABEL_H */
