/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef SYSTEMTRAY_H
#define SYSTEMTRAY_H

#include <ksystemtray.h>

class MainWindow;

/** Convenient class to develop the displayCloseMessage() dialog
  * hopefuly integrated in KDE 3.4
  * @author S�astien Laot
  */
class KSystemTray2 : public KSystemTray
{
  Q_OBJECT
  
  public:
	KSystemTray2(TQWidget *parent = 0, const char *name = 0);
	~KSystemTray2();
	/**
	  * Call this method when the user clicked the close button of the window
	  * (the [x]) to inform him that the application sit in the system tray
	  * and willn't be closed (as he is used to).
	  *
	  * You usualy call it from reimplemented TDEMainWindow::queryClose()
	  *
	  * @since 3.4
	  */
	void displayCloseMessage(TQString fileMenu = "");
};

/** This class provide a personalized system tray icon.
  * @author S�astien Laot
  */
class SystemTray : public KSystemTray2
{
  Q_OBJECT
  
  public:
	SystemTray(TQWidget *parent = 0, const char *name = 0);
	~SystemTray();
  protected:
	void mousePressEvent(TQMouseEvent *event);
	void mouseMoveEvent(TQMouseEvent *event);
	void mouseReleaseEvent(TQMouseEvent *event);
	virtual void dragEnterEvent(TQDragEnterEvent *event);
	virtual void dragMoveEvent(TQDragMoveEvent* event);
	virtual void dragLeaveEvent(TQDragLeaveEvent*);
	virtual void dropEvent(TQDropEvent *event);
	void wheelEvent(TQWheelEvent *event);
	void enterEvent(TQEvent*);
	void leaveEvent(TQEvent*);
  public slots:
	void updateToolTip();
  protected slots:
	void updateToolTipDelayed();
  signals:
	void showPart();
  private:
	TQTimer    *m_showTimer;
	TQTimer    *m_autoShowTimer;
	bool       m_canDrag;
	TQPoint     m_pressPos;
	TQPixmap    m_iconPixmap;
	TQPixmap    m_lockedIconPixmap;
};

#endif // SYSTEMTRAY_H
