/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tdeglobal.h>
#include <kstandarddirs.h>
#include <tqstring.h>
#include <tdeaction.h>
#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tqdir.h>
#include <kdebug.h>
#include <tdeconfig.h>

#include "global.h"
#include "bnpview.h"
#include "settings.h"

/** Define initial values for global variables : */

TQString            Global::s_customSavesFolder = "";
LikeBack          *Global::likeBack            = 0L;
DebugWindow       *Global::debugWindow         = 0L;
BackgroundManager *Global::backgroundManager   = 0L;
SystemTray        *Global::systemTray          = 0L;
BNPView           *Global::bnpView             = 0L;
TDEGlobalAccel      *Global::globalAccel         = 0L;
TDEConfig           *Global::basketConfig        = 0L;
AboutData          Global::basketAbout;

void Global::setCustomSavesFolder(const TQString &folder)
{
	s_customSavesFolder = folder;
}

#include <iostream>
TQString Global::savesFolder()
{
	static TQString *folder = 0L; // Memorize the folder to do not have to re-compute it each time it's needed

	if (folder == 0L) {          // Initialize it if not yet done
		if (!s_customSavesFolder.isEmpty()) { // Passed by command line (for development & debug purpose)
			TQDir dir;
			dir.mkdir(s_customSavesFolder);
			folder = new TQString(s_customSavesFolder.endsWith("/") ? s_customSavesFolder : s_customSavesFolder + "/");
		} else if (!Settings::dataFolder().isEmpty()) { // Set by config option (in Basket -> Backup & Restore)
			TQDir dir;
			dir.mkdir(s_customSavesFolder);
			folder = new TQString(Settings::dataFolder().endsWith("/") ? Settings::dataFolder() : Settings::dataFolder() + "/");
		} else { // The default path (should be that for most computers)
			folder = new TQString(TDEGlobal::dirs()->saveLocation("data", "basket/"));
		}
	}

	return *folder;
}

TQString Global::basketsFolder()     { return savesFolder() + "baskets/";     }
TQString Global::backgroundsFolder() { return savesFolder() + "backgrounds/"; }
TQString Global::templatesFolder()   { return savesFolder() + "templates/";   }
TQString Global::tempCutFolder()     { return savesFolder() + "temp-cut/";    }

TQString Global::openNoteIcon() // FIXME: Now an edit icon
{
	return Global::bnpView->m_actEditNote->icon();
}

TDEMainWindow* Global::mainWindow()
{
	TQWidget* res = kapp->mainWidget();

	if(res && res->inherits("TDEMainWindow"))
	{
		return static_cast<TDEMainWindow*>(res);
	}
	return 0;
}

TDEConfig* Global::config()
{
	if(!Global::basketConfig)
		Global::basketConfig = TDESharedConfig::openConfig("basketrc");
	return Global::basketConfig;
}
