/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tqlayout.h>
#include <tqtextbrowser.h>
#include <tqstring.h>
#include <tqevent.h>
#include <tdelocale.h>

#include "global.h"
#include "debugwindow.h"

DebugWindow::DebugWindow(TQWidget *parent, const char *name )
 : TQWidget(parent, name != 0 ? name : "DebugWindow")
{
	Global::debugWindow = this;
	setCaption(i18n("Debug Window"));

	layout      = new TQVBoxLayout(this);
	textBrowser = new TQTextBrowser(this);

	textBrowser->setWordWrap(TQTextBrowser::NoWrap);

	layout->addWidget(textBrowser);
	textBrowser->show();
}

DebugWindow::~DebugWindow()
{
	delete textBrowser;
	delete layout;
}

void DebugWindow::postMessage(const TQString msg)
{
	textBrowser->append(msg);
}

DebugWindow& DebugWindow::operator<<(const TQString msg)
{
	textBrowser->append(msg);
	return *this;
}

void DebugWindow::insertHLine()
{
	textBrowser->append("<hr>");
}

void DebugWindow::closeEvent(TQCloseEvent *event)
{
	Global::debugWindow = 0L;
	TQWidget::closeEvent(event);
}

#include "debugwindow.moc"
