/***************************************************************************
 *   Copyright (C) 2003 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef BNPVIEW_H
#define BNPVIEW_H

#include <tdelistview.h>
#include <kxmlguiclient.h>
#include <tqtimer.h>
#include <tqclipboard.h>
#include <tqsplitter.h>
#include <tqlistview.h>
#include <dcopref.h>
#include "global.h"
#include "basketdcopiface.h"

 /// NEW:

class TQWidgetStack;
class TQDomDocument;
class TQDomElement;
class TDEToggleAction;
class KPassivePopup;
class TQPopupMenu;
class TDEPopupMenu;
class KTar;

class DesktopColorPicker;
class RegionGrabber;

class Basket;
class DecoratedBasket;
class BasketListViewItem;
class NoteSelection;
class BasketStatusBar;
class Tag;
class State;
class Note;

class BNPView : public TQSplitter, virtual public BasketDcopInterface
{
	Q_OBJECT
  
	public:
	/// CONSTRUCTOR AND DESTRUCTOR:
		BNPView(TQWidget *parent, const char *name, KXMLGUIClient *aGUIClient,
				TDEActionCollection *actionCollection, BasketStatusBar *bar);
		~BNPView();
	/// MANAGE CONFIGURATION EVENTS!:
		void setTreePlacement(bool onLeft);
		void relayoutAllBaskets();
		void recomputeAllStyles();
		void removedStates(const TQValueList<State*> &deletedStates);
		void linkLookChanged();
		void filterPlacementChanged(bool onTop);
	/// MANAGE BASKETS:
		BasketListViewItem* listViewItemForBasket(Basket *basket);
		Basket* currentBasket();
		Basket* parentBasketOf(Basket *basket);
		void setCurrentBasket(Basket *basket);
		void removeBasket(Basket *basket);
	/// For NewBasketDialog (and later some other classes):
		TQListViewItem* firstListViewItem();
		///
		BasketListViewItem* lastListViewItem();
		int basketCount(TQListViewItem *parent = 0);
		bool canFold();
		bool canExpand();
		void enableActions();

	private:
		TQDomElement basketElement(TQListViewItem *item, TQDomDocument &document, TQDomElement &parentElement);
	public slots:
		void countsChanged(Basket *basket);
		void notesStateChanged();
		bool convertTexts();

		void updateBasketListViewItem(Basket *basket);
		void save();
		void save(TQListViewItem *firstItem, TQDomDocument &document, TQDomElement &parentElement);
		void saveSubHierarchy(TQListViewItem *item, TQDomDocument &document, TQDomElement &parentElement, bool recursive);
		void load();
		void load(TDEListView *listView, TQListViewItem *item, const TQDomElement &baskets);
		void loadNewBasket(const TQString &folderName, const TQDomElement &properties, Basket *parent);
		void goToPreviousBasket();
		void goToNextBasket();
		void foldBasket();
		void expandBasket();
		void closeAllEditors();
		///
		void toggleFilterAllBaskets(bool doFilter);
		void newFilter();
		void newFilterFromFilterBar();
		bool isFilteringAllBaskets();
		// From main window
		void importKNotes();
		void importKJots();
		void importKnowIt();
		void importTuxCards();
		void importStickyNotes();
		void importTomboy();
		void importTextFile();
		void backupRestore();

		/** Note */
		void activatedTagShortcut();
		void exportToHTML();
		void editNote();
		void cutNote();
		void copyNote();
		void delNote();
		void openNote();
		void openNoteWith();
		void saveNoteAs();
		void noteGroup();
		void noteUngroup();
		void moveOnTop();
		void moveOnBottom();
		void moveNoteUp();
		void moveNoteDown();
		void slotSelectAll();
		void slotUnselectAll();
		void slotInvertSelection();
		void slotResetFilter();

		void slotColorFromScreen(bool global = false);
		void slotColorFromScreenGlobal();
		void colorPicked(const TQColor &color);
		void colorPickingCanceled();
		void slotConvertTexts();

		/** Global shortcuts */
		void addNoteText();
		void addNoteHtml();
		void addNoteImage();
		void addNoteLink();
		void addNoteColor();
		/** Passive Popups for Global Actions */
		void showPassiveDropped(const TQString &title);
		void showPassiveDroppedDelayed(); // Do showPassiveDropped(), but delayed
		void showPassiveContent(bool forceShow = false);
		void showPassiveContentForced();
		void showPassiveImpossible(const TQString &message);
		void showPassiveLoading(Basket *basket);
		// For GUI :
		void setFiltering(bool filtering);
		/** Edit */
		void undo();
		void redo();
		void globalPasteInCurrentBasket();
		void pasteInCurrentBasket();
		void pasteSelInCurrentBasket();
		void pasteToBasket(int index, TQClipboard::Mode mode = TQClipboard::Clipboard);
		void showHideFilterBar(bool show, bool switchFocus = true);
		/** Insert **/
		void insertEmpty(int type);
		void insertWizard(int type);
		void grabScreenshot(bool global = false);
		void grabScreenshotGlobal();
		void screenshotGrabbed(const TQPixmap &pixmap);
		/** Basket */
		void askNewBasket();
		void askNewBasket(Basket *parent, Basket *pickProperties);
		void askNewSubBasket();
		void askNewSiblingBasket();
		void aboutToHideNewBasketPopup();
		void setNewBasketPopup();
		void cancelNewBasketPopup();
		void propBasket();
		void delBasket();
		void doBasketDeletion(Basket *basket);
		void password();
		void saveAsArchive();
		void openArchive();
		void delayedOpenArchive();
		void lockBasket();
		void hideOnEscape();

		void changedSelectedNotes();
		void timeoutTryHide();
		void timeoutHide();

	public:
		static TQString s_fileToOpen;

	public slots:
		void addWelcomeBaskets();
	private slots:
		void updateNotesActions();
		void slotBasketNumberChanged(int number);
		void slotBasketChanged();
		void currentBasketChanged();
		void isLockedChanged();
		void lateInit();
		void onFirstShow();
		void showGlobalShortcutsSettingsDialog();

	public:
		TDEAction       *m_actEditNote;
		TDEAction       *m_actOpenNote;
		TDEAction       *m_actPaste;
		TDEAction       *m_actGrabScreenshot;
		TDEAction       *m_actColorPicker;
		TDEAction       *m_actLockBasket;
		TDEAction       *m_actPassBasket;
		TDEAction       *actNewBasket;
		TDEAction       *actNewSubBasket;
		TDEAction       *actNewSiblingBasket;
		TDEAction       *m_actHideWindow;
		TDEAction       *m_actExportToHtml;
		TDEAction       *m_actPropBasket;
		TDEAction       *m_actDelBasket;
		TDEToggleAction *m_actFilterAllBaskets;

	private:
		// Basket actions:
		TDEAction       *m_actSaveAsArchive;
		TDEAction       *m_actOpenArchive;
		// Notes actions :
		TDEAction       *m_actOpenNoteWith;
		TDEAction       *m_actSaveNoteAs;
		TDEAction       *m_actGroup;
		TDEAction       *m_actUngroup;
		TDEAction       *m_actMoveOnTop;
		TDEAction       *m_actMoveNoteUp;
		TDEAction       *m_actMoveNoteDown;
		TDEAction       *m_actMoveOnBottom;
		// Edit actions :
		TDEAction       *m_actUndo;
		TDEAction       *m_actRedo;
		TDEAction       *m_actCutNote;
		TDEAction       *m_actCopyNote;
		TDEAction       *m_actDelNote;
		TDEAction       *m_actSelectAll;
		TDEAction       *m_actUnselectAll;
		TDEAction       *m_actInvertSelection;
		// Insert actions :
//		TDEAction       *m_actInsertText;
		TDEAction       *m_actInsertHtml;
		TDEAction       *m_actInsertLink;
		TDEAction       *m_actInsertImage;
		TDEAction       *m_actInsertColor;
		TDEAction       *m_actImportKMenu;
		TDEAction       *m_actInsertLauncher;
		TDEAction       *m_actImportIcon;
		TDEAction       *m_actLoadFile;
		TQPtrList<TDEAction> m_insertActions;
		// Basket actions :
		TDEToggleAction *m_actShowFilter;
		TDEAction       *m_actResetFilter;
		// Go actions :
		TDEAction       *m_actPreviousBasket;
		TDEAction       *m_actNextBasket;
		TDEAction       *m_actFoldBasket;
		TDEAction       *m_actExpandBasket;
//		TDEAction       *m_convertTexts; // FOR_BETA_PURPOSE
		TDEAction       *actConfigGlobalShortcuts;

		void setupActions();
		void setupGlobalShortcuts();
		DecoratedBasket* currentDecoratedBasket();

	public:
		Basket* loadBasket(const TQString &folderName); // Public only for class Archive
		BasketListViewItem* appendBasket(Basket *basket, TQListViewItem *parentItem); // Public only for class Archive

		Basket* basketForFolderName(const TQString &folderName);
		TQPopupMenu* popupMenu(const TQString &menuName);
		bool isPart();
		bool isMainWindowActive();
		void showMainWindow();

		// dcop calls
		virtual void newBasket();
		virtual void handleCommandLine();

	public slots:
		void setCaption(TQString s);
		void updateStatusBarHint();
		void setSelectionStatus(TQString s);
		void setLockStatus(bool isLocked);
		void postStatusbarMessage(const TQString&);
		void setStatusBarHint(const TQString&);
		void setUnsavedStatus(bool isUnsaved);
		void setActive(bool active = true);
		TDEActionCollection *actionCollection() { return m_actionCollection; };

		void populateTagsMenu();
		void populateTagsMenu(TDEPopupMenu &menu, Note *referenceNote);
		void connectTagsMenu();
		void disconnectTagsMenu();
		void disconnectTagsMenuDelayed();
	protected:
		void showEvent(TQShowEvent*);
		void hideEvent(TQHideEvent*);
	private:
		TDEPopupMenu *m_lastOpenedTagsMenu;

	private slots:
		void slotPressed(TQListViewItem *item, const TQPoint &/*pos*/ = TQPoint(), int /*column*/ = 0);
		void needSave(TQListViewItem*);
		void slotContextMenu(TDEListView *listView, TQListViewItem *item, const TQPoint &pos);
		void slotMouseButtonPressed(int button, TQListViewItem *item, const TQPoint &pos, int column);
		void slotShowProperties(TQListViewItem *item, const TQPoint&, int);
		void initialize();

	signals:
		void basketNumberChanged(int number);
		void basketChanged();
		void setWindowCaption(const TQString &s);
		void showPart();

	protected:
		void enterEvent(TQEvent*);
		void leaveEvent(TQEvent*);

	private:
		TDEListView    *m_tree;
		TQWidgetStack *m_stack;
		bool          m_loading;
		bool          m_newBasketPopup;
		bool          m_firstShow;
		DesktopColorPicker *m_colorPicker;
		bool                m_colorPickWasShown;
		bool                m_colorPickWasGlobal;
		RegionGrabber      *m_regionGrabber;
		TQString m_passiveDroppedTitle;
		NoteSelection *m_passiveDroppedSelection;
		KPassivePopup *m_passivePopup;
		static const int c_delayTooltipTime;
		TDEActionCollection *m_actionCollection;
		KXMLGUIClient *m_guiClient;
		BasketStatusBar *m_statusbar;
		TQTimer             *m_tryHideTimer;
		TQTimer             *m_hideTimer;
};

#endif // BNPVIEW_H
