/*
 * KdeMenuSample.java
 *
 * Created on 8. Marz 2002, 20:31
 */

//package com.werpu.sample3;

//import com.werpu.common.*;
import org.trinitydesktop.koala.tdejava;
import org.trinitydesktop.qt.qtjava;

import org.trinitydesktop.koala.TDEMainWindow;
import org.trinitydesktop.koala.TDECmdLineArgs;
import org.trinitydesktop.qt.TQPopupMenu;
import org.trinitydesktop.qt.TQTextView;
import org.trinitydesktop.koala.KMenuBar;
import org.trinitydesktop.koala.TDEApplication;
import org.trinitydesktop.koala.KURL;
import org.trinitydesktop.koala.KFileDialog;
import org.trinitydesktop.koala.KMessageBox;
import org.trinitydesktop.qt.TQColor;
import org.trinitydesktop.qt.TQButton;
import org.trinitydesktop.koala.KPushButton;



/**
 * @author  Werner Punz werpu@gmx.at
 * To Java translated KDE Menu Example from
 * The kde.org KDE Tutorial from Antonio Larrosa Jimenez
 * http://person.wanadoo.es/antlarr/tutorial
 */
public class KdeMenuSample extends TDEMainWindow {

   static {
      qtjava.initialize();
      tdejava.initialize();
	}

    TDEApplication kApp = null;

    /** Creates a new instance of KdeMenuSample */
    public KdeMenuSample(TDEApplication kApp) {
        super(null,"Menu Sample",1);
        this.kApp = kApp;
        setCaption("TDE Tutorial");
        createMenu();
        TQTextView centralWidget = createTextView();

        this.setCentralWidget(centralWidget);
    }


    /**
     * creates the file menu
     */
    private TQPopupMenu createFileMenu() {
        TQPopupMenu fileMenu = new TQPopupMenu(this);
        fileMenu.insertItem("&Open",this,this.SLOT("fileOpen()"));
        fileMenu.insertItem("&Save",this,this.SLOT("fileSave()"));
        fileMenu.insertItem("&Quit",kApp,kApp.SLOT("quit()"));
        return fileMenu;
    }

    /**
     * creates the about menu
     */
    private TQPopupMenu createAboutMenu() {
        StringBuffer aboutText = new StringBuffer();

        aboutText.append("Menu Example: \n ");
        aboutText.append("Originally written by Antonio Larrosa Jimenez larossa@kde.org \n");
        aboutText.append("Translated to Java by Werner Punz werpu@gmx.at \n");
        aboutText.append("Simple TDE Tutorial\n");
        aboutText.append("This tutorial comes with ABSOLUTELY NO WARRANTY\n");
        aboutText.append("This is free software, and you are welcome to redistribute it\n");
        aboutText.append("under certain conditions\n");

        TQPopupMenu aboutMenu = helpMenu(aboutText.toString(),true);

        return aboutMenu;
    }

    /**
     * creates the menu
     */
    private void createMenu() {
       KMenuBar mainMenu = kmenuBar();
       mainMenu.insertItem("&File",createFileMenu());
       mainMenu.insertSeparator();
       mainMenu.insertItem("&About",createAboutMenu());
    }

    /**
     * creates the textview of the window
     */
    private TQTextView createTextView() {
        StringBuffer textBuf = new StringBuffer();
        textBuf.append("<H2>Hello World !</H2><BR>This is a simple");
        textBuf.append(" window with <I><font size=5><B>R<font color=red");
        textBuf.append(" size=5>ich </font><font color=blue size=5>Text");
        textBuf.append("</font></B></I> capabilities<BR>Try to resize");
        textBuf.append(" this window, all this is automatic !</H2>");

        TQTextView mainTextView = new TQTextView(this,"");
        mainTextView.setText(textBuf.toString());


        return mainTextView;
    }

    //--------------------------------------------------------------
    //Slots
    //--------------------------------------------------------------
    public void fileOpen() {
         //System.out.println("File Open");
         KURL filename = KFileDialog.getOpenURL("", "*", this,"Open File" );
         String msg = "Now this app should open the url " + filename.url();
         KMessageBox.information(this , msg, "Information" , "fileOpenInformationDialog" );
    }

    public void fileSave() {
        KURL filename = KFileDialog.getSaveURL( "" , "*", this, "Save File" );
    }

    //----------------------------------------------------------------
    // main method
    //----------------------------------------------------------------
    public static void main(String [] argv) {
	TDECmdLineArgs.init(argv, "menuapp", "MenuApp",
                         "A simple menu example", "0.1");
        TDEApplication menuApp = new TDEApplication();
        KdeMenuSample mainWnd = new KdeMenuSample(menuApp);

        mainWnd.resize(100,300);
        menuApp.setMainWidget(mainWnd);

        mainWnd.show();
        menuApp.exec();
    }
}
