//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQObject;

/**

 This class offers easy use of "auto-completion", "manual-completion" or
 "shell completion" on String objects. A common use is completing filenames
 or URLs (see KURLCompletion()).
 But it is not limited to URL-completion -- everything should be completable!
 The user should be able to complete email-addresses, telephone-numbers,
 commands, SQL queries, ...
 Every time your program knows what the user can type into an edit-field, you
 should offer completion. With TDECompletion, this is very easy, and if you are
 using a line edit widget ( KLineEdit), it is even more easy.
 Basically, you tell a TDECompletion object what strings should be completable
 and whenever completion should be invoked, you call makeCompletion().
 KLineEdit and (an editable) KComboBox even do this automatically for you.
 TDECompletion offers the completed string via the signal match() and
 all matching strings (when the result is ambiguous) via the method
 allMatches().
 Notice: auto-completion, shell completion and manual completion work
         slightly differently:

	<li>
	auto-completion always returns a complete item as match.
	     When more than one matching items are available, it will deliver just
	     the first (depending on sorting order) item. Iterating over all matches
	     is possible via nextMatch() and previousMatch().
	</li>

	<li>
	popup-completion works in the same way, the only difference being that
	     the completed items are not put into the edit-widget, but into a
	     separate popup-box.
	</li>

	<li>
	manual completion works the same way as auto-completion, the
	     subtle difference is, that it isn't invoked automatically while the user
	     is typing, but only when the user presses a special key. The difference
	     of manual and auto-completion is therefore only visible in UI classes,
	     TDECompletion needs to know whether to deliver partial matches
	     (shell completion) or whole matches (auto/manual completion), therefore
	 TDEGlobalSettings.CompletionMan and
	 TDEGlobalSettings.CompletionAuto have the exact same effect in
	     TDECompletion.
	</li>

	<li>
	shell completion works like how shells complete filenames:
	     when multiple matches are available, the longest possible string of all
	     matches is returned (i.e. only a partial item).
	     Iterating over all matching items (complete, not partial) is possible
	     via nextMatch() and previousMatch().
	</li>
	 You don't have to worry much about that though, TDECompletion handles
 that for you, according to the setting setCompletionMode().
 The default setting is globally configured by the user and read
 from TDEGlobalSettings.completionMode().
 A short example:
 <pre>
 TDECompletion completion;
 completion.setOrder( TDECompletion.Sorted );
 completion.addItem( "pfeiffer@kde.org" );
 completion.addItem( "coolo@kde.org" );
 completion.addItem( "carpdjih@sp.zrz.tu-berlin.de" );
 completion.addItem( "carp@cs.tu-berlin.de" );
 cout << completion.makeCompletion( "ca" ).latin1() << endl;
 </pre>
 In shell-completion-mode, this will be "carp"; in auto-completion-
 mode it will be "carp\@cs.tu-berlin.de", as that is alphabetically
 smaller.
 If setOrder was set to Insertion, "carpdjih\@sp.zrz.tu-berlin.de"
 would be completed in auto-completion-mode, as that was inserted before
 "carp\@cs.tu-berlin.de".
 You can dynamically update the completable items by removing and adding them
 whenever you want.
 For advanced usage, you could even use multiple TDECompletion objects. E.g.
 imagine an editor like kwrite with multiple open files. You could store
 items of each file in a different TDECompletion object, so that you know (and
 tell the user) where a completion comes from.
 Note: TDECompletion does not work with strings that contain 0x0 characters
       (unicode nul), as this is used internally as a delimiter.
 You may inherit from TDECompletion and override makeCompletion() in
 special cases (like reading directories/urls and then supplying the
 contents to TDECompletion, as KURLCompletion does), but generally, this is
 not necessary.
 See {@link TDECompletionSignals} for signals emitted by TDECompletion
		@author Carsten Pfeiffer <pfeiffer@kde.org>

		@short A generic class for completing Strings.

*/
public class TDECompletion extends TQObject  {
	protected TDECompletion(Class dummy){super((Class) null);}
	/**
		 Constants that represent the order in which TDECompletion performs
		 completion-lookups.
		     		@short    Constants that represent the order in which TDECompletion performs  completion-lookups.
	*/
	public static final int Sorted = 0;
	public static final int Insertion = 1;
	public static final int Weighted = 2;

	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Constructor, nothing special here :)
		     		@short    Constructor, nothing special here :)
	*/
	public TDECompletion() {
		super((Class) null);
		newTDECompletion();
	}
	private native void newTDECompletion();
	/**
		 Attempts to find an item in the list of available completions,
		 that begins with <code>string.</code> Will either return the first matching item
		 (if there is more than one match) or null, if no match was
		 found.
			 In the latter case, a sound will be issued, depending on
		 isSoundsEnabled().
		 If a match was found, it will also be emitted via the signal
		 match().
			 If this is called twice or more often with the same string while no
		 items were added or removed in the meantime, all available completions
		 will be emitted via the signal #matches().
		 This happens only in shell-completion-mode.
			@param string the string to complete
				@return the matching item, or null if there is no matching
 item.

		@short    Attempts to find an item in the list of available completions,  that begins with <code>string.</code>
		@see #slotMakeCompletion
		@see #substringCompletion
	*/
	public native String makeCompletion(String string);
	/**
		 Returns a list of all completion items that contain the given <code>string.</code>
			@param string the string to complete
				@return a list of items which all contain <code>text</code> as a substring,
 i.e. not necessarily at the beginning.

		@short    Returns a list of all completion items that contain the given <code>string.</code>
		@see #makeCompletion
	*/
	public native ArrayList substringCompletion(String string);
	/**
		 Returns the next item from the matching-items-list.
		 When reaching the beginning, the list is rotated so it will return the
		 last match and a sound is issued (depending on isSoundsEnabled()).
				@return the next item from the matching-items-list.
 When there is no match, null is returned and
 a sound is be issued.

		@short    Returns the next item from the matching-items-list.
		@see #slotPreviousMatch
	*/
	public native String previousMatch();
	/**
		 Returns the next item from the matching-items-list.
		 When reaching the last item, the list is rotated, so it will return
		 the first match and a sound is issued (depending on
		 isSoundsEnabled()).
				@return the next item from the matching-items-list.  When there is no
 match, null is returned and a sound is issued

		@short    Returns the next item from the matching-items-list.
		@see #slotNextMatch
	*/
	public native String nextMatch();
	/**
		 Returns the last match. Might be useful if you need to check whether
		 a completion is different from the last one.
				@return the last match. null is returned when there is no
         last match.

		@short    Returns the last match.
	*/
	public native String lastMatch();
	/**
		 Returns a list of all items inserted into TDECompletion. This is useful
		 if you need to save the state of a TDECompletion object and restore it
		 later.
			 Important note: when order() == Weighted, then every item in the
		 stringlist has its weight appended, delimited by a colon. E.g. an item
		 "www.kde.org" might look like "www.kde.org:4", where 4 is the weight.
			 This is necessary so that you can save the items along with its
		 weighting on disk and load them back with setItems(), restoring its
		 weight as well. If you really don't want the appended weightings, call
		 setOrder( TDECompletion.Insertion )
		 before calling items().
				@return a list of all items

		@short    Returns a list of all items inserted into TDECompletion.
		@see #setItems
	*/
	public native ArrayList items();
	/**
		 Returns true when the completion object contains no entries.
		     		@short    Returns true when the completion object contains no entries.
	*/
	public native boolean isEmpty();
	/**
		 Sets the completion mode to Auto/Manual, Shell or None.
		 If you don't set the mode explicitly, the global default value
		 TDEGlobalSettings.completionMode() is used.
		 TDEGlobalSettings.CompletionNone disables completion.
			@param mode the completion mode
				@short    Sets the completion mode to Auto/Manual, Shell or None.
		@see #completionMode
		@see TDEGlobalSettings#completionMode
	*/
	public native void setCompletionMode(int mode);
	/**
		 Return the current completion mode.
		 May be different from TDEGlobalSettings.completionMode(), if you
		 explicitly called setCompletionMode().
				@return the current completion mode

		@short    Return the current completion mode.
		@see #setCompletionMode
	*/
	public native int completionMode();
	/**
		 TDECompletion offers three different ways in which it offers its items:

			<li>
			in the order of insertion
			</li>

			<li>
			sorted alphabetically
			</li>

			<li>
			weighted
			</li>
				 Choosing weighted makes TDECompletion perform an implicit weighting based
		 on how often an item is inserted. Imagine a web browser with a location
		 bar, where the user enters URLs. The more often a URL is entered, the
		 higher priority it gets.
			 Note: Setting the order to sorted only affects new inserted items,
		 already existing items will stay in the current order. So you probably
		 want to call setOrder( Sorted ) before inserting items, when you want
		 everything sorted.
			 Default is insertion order.
			@param order the new order
				@short    TDECompletion offers three different ways in which it offers its items:
		@see #order
	*/
	public native void setOrder(int order);
	/**
		 Returns the completion order.
				@return the current completion order.

		@short    Returns the completion order.
		@see #setOrder
	*/
	public native int order();
	/**
		 Setting this to true makes TDECompletion behave case insensitively.
		 E.g. makeCompletion( "CA" ); might return "carp\@cs.tu-berlin.de".
		 Default is false (case sensitive).
			@param ignoreCase true to ignore the case
				@short    Setting this to true makes TDECompletion behave case insensitively.
		@see #ignoreCase
	*/
	public native void setIgnoreCase(boolean ignoreCase);
	/**
		 Return whether TDECompletion acts case insensitively or not.
		 Default is false (case sensitive).
				@return true if the case will be ignored

		@short    Return whether TDECompletion acts case insensitively or not.
		@see #setIgnoreCase
	*/
	public native boolean ignoreCase();
	/**
		 Returns a list of all items matching the last completed string.
		 Might take some time, when you have LOTS of items.
				@return a list of all matches for the last completed string.

		@short    Returns a list of all items matching the last completed string.
		@see #substringCompletion
	*/
	public native ArrayList allMatches();
	/**
		 Returns a list of all items matching <code>string.</code>
			@param string the string to match
				@return the list of all matches

		@short    Returns a list of all items matching <code>string.</code>
	*/
	public native ArrayList allMatches(String string);
	/**
		 Returns a list of all items matching the last completed string.
		 Might take some time, when you have LOTS of items.
		 The matches are returned as TDECompletionMatches, which also
		 keeps the weight of the matches, allowing
		 you to modify some matches or merge them with matches
		 from another call to allWeightedMatches(), and sort the matches
		 after that in order to have the matches ordered correctly.
				@return a list of all completion matches

		@short    Returns a list of all items matching the last completed string.
		@see #substringCompletion
	*/
	// TDECompletionMatches allWeightedMatches(); >>>> NOT CONVERTED
	/**
		 Returns a list of all items matching <code>string.</code>
			@param string the string to match
				@return a list of all matches

		@short    Returns a list of all items matching <code>string.</code>
	*/
	// TDECompletionMatches allWeightedMatches(const TQString& arg1); >>>> NOT CONVERTED
	/**
		 Enables/disables playing a sound when

			<li>
			makeCompletion() can't find a match
			</li>

			<li>
			there is a partial completion (= multiple matches in
			     Shell-completion mode)
			</li>

			<li>
			nextMatch() or previousMatch() hit the last possible
			     match . rotation
			</li>
				 For playing the sounds, KNotifyClient() is used.
			@param enable true to enable sounds
				@short    Enables/disables playing a sound when
		@see #isSoundsEnabled
	*/
	public native void setEnableSounds(boolean enable);
	/**
		 Tells you whether TDECompletion will play sounds on certain occasions.
		 Default is enabled.
				@return true if sounds are enabled

		@short    Tells you whether TDECompletion will play sounds on certain occasions.
		@see #enableSounds
		@see #disableSounds
	*/
	public native boolean isSoundsEnabled();
	/**
		 Returns true when more than one match is found.
				@return true if there are more than one match

		@short    Returns true when more than one match is found.
		@see #multipleMatches
	*/
	public native boolean hasMultipleMatches();
	/**
		 Attempts to complete "string" and emits the completion via match().
		 Same as makeCompletion() (just as a slot).
			@param string the string to complete
				@short    Attempts to complete "string" and emits the completion via match().
		@see #makeCompletion
	*/
	public native void slotMakeCompletion(String string);
	/**
		 Searches the previous matching item and emits it via match().
		 Same as previousMatch() (just as a slot).
				@short    Searches the previous matching item and emits it via match().
		@see #previousMatch
	*/
	public native void slotPreviousMatch();
	/**
		 Searches the next matching item and emits it via match().
		 Same as nextMatch() (just as a slot).
				@short    Searches the next matching item and emits it via match().
		@see #nextMatch
	*/
	public native void slotNextMatch();
	/**
		 Inserts <code>items</code> into the list of possible completions.
		 Does the same as setItems(), but does not call clear() before.
			@param items the items to insert
		     		@short    Inserts <code>items</code> into the list of possible completions.
	*/
	public native void insertItems(String[] items);
	/**
		 Sets the list of items available for completion. Removes all previous
		 items.
			 Notice: when order() == Weighted, then the weighting is looked up for
		 every item in the stringlist. Every item should have ":number" appended,
		 where number is an unsigned integer, specifying the weighting.
			 If you don't like this, call
		 setOrder( TDECompletion.Insertion )
		 before calling setItems().
			@param list the list of items that are available for completion
				@short    Sets the list of items available for completion.
		@see #items
	*/
	public native void setItems(String[] list);
	/**
		 Adds an item to the list of available completions.
		 Resets the current item-state ( previousMatch() and nextMatch()
		 won't work anymore).
			@param item the item to add
		     		@short    Adds an item to the list of available completions.
	*/
	public native void addItem(String item);
	/**
		 Adds an item to the list of available completions.
		 Resets the current item-state ( previousMatch() and nextMatch()
		 won't work anymore).
			 Sets the weighting of the item to <code>weight</code> or adds it to the current
		 weighting if the item is already available. The weight has to be greater
		 than 1 to take effect (default weight is 1).
			@param item the item to add
			@param weight the weight of the item, default is 1
		     		@short    Adds an item to the list of available completions.
	*/
	public native void addItem(String item, int weight);
	/**
		 Removes an item from the list of available completions.
		 Resets the current item-state ( previousMatch() and nextMatch()
		 won't work anymore).
			@param item the item to remove
		     		@short    Removes an item from the list of available completions.
	*/
	public native void removeItem(String item);
	/**
		 Removes all inserted items.
		     		@short    Removes all inserted items.
	*/
	public native void clear();
	/**
		 This method is called after a completion is found and before the
		 matching string is emitted. You can override this method to modify the
		 string that will be emitted.
		 This is necessary e.g. in KURLCompletion(), where files with spaces
		 in their names are shown escaped ("filename\ with\ spaces"), but stored
		 unescaped inside TDECompletion.
		 Never delete that pointer!
			 Default implementation does nothing.
			@param match the match to process
				@short    This method is called after a completion is found and before the  matching string is emitted.
		@see #postProcessMatches
	*/
	protected native void postProcessMatch(StringBuffer match);
	/**
		 This method is called before a list of all available completions is
		 emitted via #matches. You can override this method to modify the
		 found items before match() or #matches are emitted.
		 Never delete that pointer!
			 Default implementation does nothing.
			@param matches the matches to process
				@short    This method is called before a list of all available completions is  emitted via #matches.
		@see #postProcessMatch
	*/
	protected native void postProcessMatches(String[] matches);
	/**
		 This method is called before a list of all available completions is
		 emitted via #matches. You can override this method to modify the
		 found items before #match() or #matches() are emitted.
		 Never delete that pointer!
			 Default implementation does nothing.
			@param matches the matches to process
				@short    This method is called before a list of all available completions is  emitted via #matches.
		@see #postProcessMatch
	*/
	// void postProcessMatches(TDECompletionMatches* arg1); >>>> NOT CONVERTED
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
