/***************************************************************************
*   Copyright (C) 2003 by Roberto Raggi                                   *
*   roberto@kdevelop.org                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef CODEINFORMATIONREPOSITORY_H
#define CODEINFORMATIONREPOSITORY_H

#include "catalog.h"
#include "cppcodecompletion.h"
#include <tqmap.h>

#include <tdetexteditor/codecompletioninterface.h>

struct TypeProcessor {
    virtual TQString processType( const TQString& type ) = 0;
    virtual TQString parentType() = 0;
};

class KDevCodeRepository;

class CodeInformationRepository
{
public:
	CodeInformationRepository( KDevCodeRepository* rep );
	virtual ~CodeInformationRepository();

	static TQValueList<KTextEditor::CompletionEntry> toEntryList( const TQValueList<Tag>& tags,
	        CppCodeCompletion::CompletionMode mode = CppCodeCompletion::NormalCompletion );
	static KTextEditor::CompletionEntry toEntry( Tag& tag, CppCodeCompletion::CompletionMode mode = CppCodeCompletion::NormalCompletion, TypeProcessor* proc = 0 );
	TQValueList<KTextEditor::CompletionEntry> getEntriesInScope( const TQStringList& scope, bool isInstance, bool recompute = false );

	TQValueList<Tag> query( const TQValueList<Catalog::QueryArgument>& args );
	TQValueList<Tag> getTagsInScope( const TQStringList& scope, bool isInstance );
	TQValueList<Tag> getTagsInScope( const TQString& name, const TQStringList& scope );

	TQValueList<Tag> getTagsInFile( const TQString& fileName );
	TQValueList<Tag> getBaseClassList( const TQString& className );
	TQValueList<Tag> getClassOrNamespaceList( const TQStringList& scope );

private:
	TQValueList<KTextEditor::CompletionEntry> m_globalEntries;
	KDevCodeRepository* m_rep;

private:
	CodeInformationRepository( const CodeInformationRepository& source );
	void operator = ( const CodeInformationRepository& source );
};

#endif 
// kate: indent-mode csands; tab-width 4;

