/***************************************************************************
 *   Copyright (C) 2007 by Andreas Pakulat                                 *
 *   apaku@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SELECTNEWFILESDIALOG_H
#define SELECTNEWFILESDIALOG_H

#include "kdialogbase.h"

class TQCheckListItem;
class TQStringList;
class SelectNewFilesDialogBase;

class SelectNewFilesDialog : public KDialogBase
{
Q_OBJECT
  

public:
    SelectNewFilesDialog( TQStringList paths, TQWidget* parent = 0, const char* name = 0 );
    ~SelectNewFilesDialog();

    TQStringList excludedPaths() const;
    TQStringList includedPaths() const;

public slots:
    /*$PUBLIC_SLOTS$*/

protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/
    virtual void slotCancel();
    virtual void slotOk();
private:
    void addPath( TQCheckListItem* , const TQString& );
    void checkItem( TQCheckListItem* item, const TQString& curpath );
    TQCheckListItem* createItem( TQCheckListItem*, const TQString&, int );
    SelectNewFilesDialogBase* m_widget;
    TQStringList excludePaths;
    TQStringList includePaths;
};

#endif

// kate: space-indent on; indent-width 4; tab-width 4; replace-tabs on
