/*
    kopetestdaction.cpp  -  Kopete Standard Actionds

    Copyright (c) 2001-2002 by Ryan Cumming          <ryan@kde.org>
    Copyright (c) 2002-2003 by Martijn Klingens      <klingens@kde.org>

    Kopete    (c) 2001-2003 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include "kopetestdaction.h"

#include <tqapplication.h>

#include <kdebug.h>
#include <tdeversion.h>
#include <kguiitem.h>
#include <tdelocale.h>
#include <ksettings/dialog.h>
#include <kstdaction.h>
#include <kstdguiitem.h>
#include <twin.h>
#include <kcmultidialog.h>

#include "kopetecontactlist.h"
#include "kopetegroup.h"
#include "kopeteuiglobal.h"

KSettings::Dialog *KopetePreferencesAction::s_settingsDialog = 0L;

KopetePreferencesAction::KopetePreferencesAction( TDEActionCollection *parent, const char *name )

: TDEAction( KGuiItem( i18n( "&Configure Kopete..." ),
	TQString::fromLatin1( "configure" ) ), 0, 0, 0, parent, name )

{
	connect( this, TQT_SIGNAL( activated() ), this, TQT_SLOT( slotShowPreferences() ) );
}

KopetePreferencesAction::~KopetePreferencesAction()
{
}

void KopetePreferencesAction::slotShowPreferences()
{
	// FIXME: Use static deleter - Martijn
	if ( !s_settingsDialog )
		s_settingsDialog = new KSettings::Dialog( KSettings::Dialog::Static, Kopete::UI::Global::mainWidget() );
	s_settingsDialog->show();

	s_settingsDialog->dialog()->raise();

	KWin::activateWindow( s_settingsDialog->dialog()->winId() );
}

TDEAction * KopeteStdAction::preferences( TDEActionCollection *parent, const char *name )
{
	return new KopetePreferencesAction( parent, name );
}

TDEAction * KopeteStdAction::chat( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "Start &Chat..." ), TQString::fromLatin1( "mail_generic" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::sendMessage( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "&Send Single Message..." ), TQString::fromLatin1( "mail_generic" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::contactInfo( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "User &Info" ), TQString::fromLatin1( "messagebox_info" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::sendFile( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "Send &File..." ), TQString::fromLatin1( "attach" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::viewHistory( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "View &History..." ), TQString::fromLatin1( "history" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::addGroup( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "&Create Group..." ), TQString::fromLatin1( "folder" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::changeMetaContact( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "Cha&nge Meta Contact..." ), TQString::fromLatin1( "move" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::deleteContact( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "&Delete Contact" ), TQString::fromLatin1( "delete_user" ), TQt::Key_Delete, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::changeAlias( const TQObject *recvr, const char *slot, TQObject *parent, const char *name )
{
	return new TDEAction( i18n( "Change A&lias..." ), TQString::fromLatin1( "signature" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::blockContact( const TQObject *recvr, const char *slot, TQObject* parent, const char *name )
{
	return new TDEAction( i18n( "&Block Contact" ), TQString::fromLatin1( "media-playback-pause" ), 0, recvr, slot, parent, name );
}

TDEAction * KopeteStdAction::unblockContact( const TQObject *recvr, const char *slot, TQObject* parent, const char *name )
{
	return new TDEAction( i18n( "Un&block Contact" ), TQString::fromLatin1( "media-playback-start" ), 0, recvr, slot, parent, name );
}

#include "kopetestdaction.moc"

// vim: set noet ts=4 sts=4 sw=4:

