###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


##### check for libusb

if( WITH_LIBUSB )

  pkg_search_module( LIBUSB libusb libusb-2.0 )
  if( NOT LIBUSB_FOUND )
    tde_message_fatal( "libusb support has been requested, but was not found on your system" )
  endif( NOT LIBUSB_FOUND )

endif( WITH_LIBUSB )


##### check for pthread

find_package ( Threads REQUIRED )


##### check for zlib

find_package ( ZLIB REQUIRED )


##### check for math lib

check_library_exists( m sincos "" LIBM )
if( LIBM )
    set( LIBM m )
endif( LIBM )


##### check for v4l

if( WITH_V4L )
  check_include_file( "linux/videodev2.h" HAVE_LINUX_VIDEODEV2_H )

  if( NOT HAVE_LINUX_VIDEODEV2_H )
    check_include_file( "linux/videodev.h" HAVE_LINUX_VIDEODEV_H )
    if( NOT HAVE_LINUX_VIDEODEV_H )
      tde_message_fatal( "video4linux support is requested, but videodev2.h or videodev.h was not found on your system" )
    endif( )
  endif( )
endif( )


##### check platform OS

message( STATUS "Cheking platform - ${CMAKE_SYSTEM_NAME}" )

if( ${CMAKE_SYSTEM_NAME} MATCHES "Linux" )
  set( OS_Linux true )
  set( LIB_FLI fli_linux-static )
elseif( ${CMAKE_SYSTEM_NAME} MATCHES "OpenBSD|FreeBSD|DragonFly|NetBSD" )
  set( OS_BSD true )
  set( LIB_FLI fli_bsd-static )
else( )
  set( OS_UNKNOWN true )
  set( LIB_FLI fli_null-static )
endif( )
