/***************************************************************************
 *   Copyright (C) 2003-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef PCHECKBOX_H
#define PCHECKBOX_H

#include "propertywidget.h"

class TQCheckBox;

namespace PropertyLib{

/**
@short %Property editor with checkbox.
*/
class PCheckBox: public PropertyWidget{
    Q_OBJECT
  
public:
    PCheckBox(MultiProperty *property, TQWidget *parent = 0, const char *name = 0);

    /**@return the value currently entered in the editor widget.*/
    virtual TQVariant value() const;
    /**Sets the value shown in the editor widget. Set emitChange to false
    if you don't want to emit propertyChanged signal.*/
    virtual void setValue(const TQVariant &value, bool emitChange=true);
    /**Function to draw a property viewer when the editor isn't shown.*/
    virtual void drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value);

private slots:
    void updateProperty(bool val);
    
private:
    TQCheckBox *m_edit;
};

}

#endif
