#ifndef KBB_BUGJOB_H
#define KBB_BUGJOB_H

#include <tdeio/jobclasses.h>

#include "bugserver.h"

class BugJob : public TDEIO::Job
{
    Q_OBJECT
  
  public:
    BugJob( BugServer * );
    virtual ~BugJob();

    BugServer *server() const { return mServer; }

  signals:
    void infoMessage( const TQString &text );
    void infoPercent( unsigned long percent );
    void error( const TQString &text );
    void jobEnded( BugJob * );

  protected:
    void start( const KURL &url /*, const KParts::URLArgs &args = KParts::URLArgs()*/ );

    virtual void process( const TQByteArray &data ) = 0;

  private slots:
    void ioResult( TDEIO::Job *job );

    void ioData( TDEIO::Job *job, const TQByteArray &data );

    void ioInfoMessage( TDEIO::Job *job, const TQString &text );

    void ioInfoPercent( TDEIO::Job *job, unsigned long percent );

  private:
    TQByteArray m_data;
    BugServer *mServer;
};

#endif
/*
 * vim:sw=4:ts=4:et
 */
