/*  -*- c++ -*-
    attachmentlistview.cpp

    KMail, the KDE mail client.
    Copyright (c) 2003 Ingo Kloecker <kloecker@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License,
    version 2.0, as published by the Free Software Foundation.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, US
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// my header file
#include "attachmentlistview.h"

// other KMail headers
#include "kmmsgbase.h"
#include "kmfolder.h"
#include "kmcommands.h"
#include "kmmsgdict.h"
#include "composer.h"

// other module headers
#include <maillistdrag.h>
using KPIM::MailListDrag;

// other KDE headers
#include <kurldrag.h>

// other TQt headers
#include <tqevent.h>
#include <tqcstring.h>
#include <tqbuffer.h>
#include <tqptrlist.h>
#include <tqdatastream.h>
#include <tqstring.h>

// other headers (none)


namespace KMail {

AttachmentListView::AttachmentListView( KMail::Composer * composer,
                                        TQWidget* parent,
                                        const char* name )
  : TDEListView( parent, name ),
    mComposer( composer )
{
  setAcceptDrops( true );
  setDragEnabled( true );
}

//-----------------------------------------------------------------------------

AttachmentListView::~AttachmentListView()
{
}

//-----------------------------------------------------------------------------

void AttachmentListView::contentsDragEnterEvent( TQDragEnterEvent* e )
{
  if( e->provides( MailListDrag::format() ) || KURLDrag::canDecode( e ) )
    e->accept( true );
  else
    TDEListView::dragEnterEvent( e );
}

//-----------------------------------------------------------------------------

void AttachmentListView::contentsDragMoveEvent( TQDragMoveEvent* e )
{
  if( e->provides( MailListDrag::format() ) || KURLDrag::canDecode( e ) )
    e->accept( true );
  else
    TDEListView::dragMoveEvent( e );
}

//-----------------------------------------------------------------------------

void AttachmentListView::contentsDropEvent( TQDropEvent* e )
{
  if( e->provides( MailListDrag::format() ) ) {
    // Decode the list of serial numbers stored as the drag data
    TQByteArray serNums;
    MailListDrag::decode( e, serNums );
    TQBuffer serNumBuffer( serNums );
    serNumBuffer.open( IO_ReadOnly );
    TQDataStream serNumStream( &serNumBuffer );
    TQ_UINT32 serNum;
    KMFolder *folder = 0;
    int idx;
    TQPtrList<KMMsgBase> messageList;
    while( !serNumStream.atEnd() ) {
      KMMsgBase *msgBase = 0;
      serNumStream >> serNum;
      KMMsgDict::instance()->getLocation( serNum, &folder, &idx );
      if( folder )
        msgBase = folder->getMsgBase( idx );
      if( msgBase )
        messageList.append( msgBase );
    }
    serNumBuffer.close();
    uint identity = folder ? folder->identity() : 0;
    KMCommand *command = new KMForwardAttachedCommand( mComposer, messageList,
                                                       identity, mComposer );
    command->start();
  }
  else if( KURLDrag::canDecode( e ) ) {
    KURL::List urlList;
    if( KURLDrag::decode( e, urlList ) ) {
      for( KURL::List::Iterator it = urlList.begin();
           it != urlList.end(); ++it ) {
        mComposer->addAttach( *it );
      }
    }
  }
  else {
    TDEListView::dropEvent( e );
  }
}

//-----------------------------------------------------------------------------

void AttachmentListView::keyPressEvent( TQKeyEvent * e )
{
  if ( e->key() == Key_Delete ) {
    emit attachmentDeleted();
  }
}

/*virtual*/
void AttachmentListView::startDrag()
{
    emit dragStarted();
}

} // namespace KMail

#include "attachmentlistview.moc"
