#ifndef KSTICKER_H
#define KSTICKER_H

#include <tqobject.h>
#include <tqframe.h>
#include <tqstring.h>
#include <tqptrlist.h>
#include <tqpopupmenu.h>

class SInfo {
public:
  int length;
};

class KSTicker : public TQFrame
{
  Q_OBJECT
  

public:
  KSTicker(TQWidget * parent=0, const char * name=0, WFlags f=0);
  virtual ~KSTicker();

  void setString(TQString);
  void mergeString(TQString);
  void mergeString(TQString, TQColor);

  virtual void show();
  virtual void hide();

  void speed(int *, int *);

  virtual void setBackgroundColor ( const TQColor & );
  virtual void setPalette ( const TQPalette & p );

signals:
  void doubleClick();
  void closing();

public slots:
  virtual void setSpeed(int, int);

protected slots:
  virtual void fontSelector();
  virtual void scrollRate();
  virtual void updateFont(const TQFont &font);
  virtual void scrollConstantly();

protected:
  virtual void timerEvent ( TQTimerEvent * );
  virtual void paintEvent ( TQPaintEvent * );
  virtual void resizeEvent( TQResizeEvent * );
  virtual void closeEvent( TQCloseEvent * );
  virtual void mouseDoubleClickEvent( TQMouseEvent * );
  virtual void mousePressEvent ( TQMouseEvent * );
  virtual void iconify();


private:

    TQString stripCols(TQString);

    TQStringList strlist;   /* everything left to parse */
    TQStringList strbuffer; /* fifo of the last 10 lines to scroll in scroll constantly mode */
    TQStringList tipbuffer; /* 5 lines for the tooltip */
    TQString currentStr;   /* the string we are currently parsing */

    TQFont ourFont;

    int onechar;
    int chars;
    int descent;

    int tickStep;
    int cOffset;

    int tickRate;

    int pHeight;

    int currentChar;

    void startTicker();
    void stopTicker();

    bool bScrollConstantly;
    int iScrollItem;
    bool bAtEnd;

    TQPixmap *pic;

    TQPopupMenu *popup;

    /*
     * Drawing settings and variables
     */
    bool bold;
    bool underline;
    bool italics;
    TQColor defbg;
    TQColor deffg;
    TQColor bg;
    TQColor fg;
};

#endif // KSTICKER_H

