/*  *************************************************************************
    *   copyright: (C) 2003 Richard Lrkng <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef SMSPROTOCOL_H
#define SMSPROTOCOL_H

#include <tqmap.h>
#include <tqmovie.h>
#include <tqpixmap.h>
#include <tqptrdict.h>
#include <tqptrlist.h>
#include <tqstringlist.h>

#include "kopeteprotocol.h"
#include "kopeteonlinestatus.h"
#include "kopetecontact.h"

class TDEAction;
class TDEActionMenu;

namespace Kopete { class Contact; }
namespace Kopete { class MetaContact; }
namespace Kopete { class Message; }
namespace Kopete { class ChatSession; }
class SMSContact;

class SMSProtocol : public Kopete::Protocol
{
	Q_OBJECT
  

public:
	SMSProtocol(TQObject *parent, const char *name, const TQStringList &args);
	~SMSProtocol();

	static SMSProtocol *protocol();

	/**
	 * Deserialize contact data
	 */
	virtual Kopete::Contact *deserializeContact(Kopete::MetaContact *metaContact,
		const TQMap<TQString, TQString> &serializedData, const TQMap<TQString, TQString> &addressBookData );

	virtual AddContactPage *createAddContactWidget(TQWidget *parent , Kopete::Account *i);
	virtual KopeteEditAccountWidget *createEditAccountWidget(Kopete::Account *account, TQWidget *parent);
	virtual Kopete::Account *createNewAccount(const TQString &accountId);

	const Kopete::OnlineStatus SMSOnline;
	const Kopete::OnlineStatus SMSOffline;
	const Kopete::OnlineStatus SMSConnecting;

private:
	static SMSProtocol *s_protocol;
};

#endif

// vim: set noet ts=4 sts=4 sw=4:

