/*  *************************************************************************
    *   copyright: (C) 2003 Richard L�k�g <nouseforaname@home.se>         *
    *   copyright: (C) 2003 Gav Wood <gav@kde.org>                          *
    *************************************************************************
*/

/*  *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <tqcombobox.h>
#include <tqvgroupbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqtooltip.h>

#include <tdeconfigbase.h>
#include <klineedit.h>
#include <tdelocale.h>
#include <kurlrequester.h>
#include <tdemessagebox.h>
#include <kdebug.h>

#include "kopeteaccount.h"
#include "kopeteuiglobal.h"

#include "smssend.h"
#include "smssendprefs.h"
#include "smssendprovider.h"
#include "smsprotocol.h"

SMSSend::SMSSend(Kopete::Account* account)
	: SMSService(account)
{
	kdWarning( 14160 ) << k_funcinfo << " this = " << this << endl;
	prefWidget = 0L;
	m_provider = 0L;
}

SMSSend::~SMSSend()
{
}

void SMSSend::send(const Kopete::Message& msg)
{
	kdWarning( 14160 ) << k_funcinfo << "m_account = " << m_account << " (should be non-zero!!)" << endl;
	TQString provider = m_account->configGroup()->readEntry("SMSSend:ProviderName", TQString());

	if (provider.length() < 1)
	{
		KMessageBox::error(Kopete::UI::Global::mainWidget(), i18n("No provider configured."), i18n("Could Not Send Message"));
		return;
	}

	TQString prefix = m_account->configGroup()->readEntry("SMSSend:Prefix", TQString());
	if (prefix.isNull())
	{
		KMessageBox::error(Kopete::UI::Global::mainWidget(), i18n("No prefix set for SMSSend, please change it in the configuration dialog."), i18n("No Prefix"));
		return;
	}

	m_provider = new SMSSendProvider(provider, prefix, m_account, this);

	TQObject::connect( m_provider, TQT_SIGNAL(messageSent(const Kopete::Message &)), this, TQT_SIGNAL(messageSent(const Kopete::Message &)));
	TQObject::connect( m_provider, TQT_SIGNAL(messageNotSent(const Kopete::Message &, const TQString &)), this, TQT_SIGNAL(messageNotSent(const Kopete::Message &, const TQString &)));

	m_provider->send(msg);
}

void SMSSend::setWidgetContainer(TQWidget* parent, TQGridLayout* layout)
{
	kdWarning( 14160 ) << k_funcinfo << "ml: " << layout << ", " << "mp: " << parent << endl;
	m_parent = parent;
	m_layout = layout;

	// could end up being deleted twice??
	delete prefWidget;
	prefWidget = new SMSSendPrefsUI(parent);
	layout->addMultiCellWidget(prefWidget, 0, 1, 0, 1);

	prefWidget->program->setMode(KFile::Directory);

	TQString prefix = TQString();

	if (m_account)
		prefix = m_account->configGroup()->readEntry("SMSSend:Prefix", TQString());
	if (prefix.isNull())
	{
		TQDir d("/usr/share/smssend");
		if (d.exists())
		{
			prefix = "/usr";
		}
		d = "/usr/local/share/smssend";
		if (d.exists())
		{
			prefix="/usr/local";
		}
		else
		{
			prefix="/usr";
		}
	}

	TQObject::connect (prefWidget->program, TQT_SIGNAL(textChanged(const TQString &)),
		this, TQT_SLOT(loadProviders(const TQString&)));

	prefWidget->program->setURL(prefix);

	TQObject::connect(prefWidget->provider, TQT_SIGNAL(activated(const TQString &)),
		this, TQT_SLOT(setOptions(const TQString &)));

	prefWidget->show();
}

void SMSSend::savePreferences()
{
	if (prefWidget != 0L && m_account != 0L && m_provider != 0L )
	{
		m_account->configGroup()->writeEntry("SMSSend:Prefix", prefWidget->program->url());
		m_account->configGroup()->writeEntry("SMSSend:ProviderName", prefWidget->provider->currentText());
		m_provider->save(args);
	}
}

void SMSSend::loadProviders(const TQString &prefix)
{
	kdWarning( 14160 ) << k_funcinfo << "m_account = " << m_account << " (should be ok if zero)" << endl;

	TQStringList p;

	prefWidget->provider->clear();

	TQDir d(prefix + "/share/smssend");
	if (!d.exists())
	{
		setOptions(TQString());
		return;
	}

	p = d.entryList("*.sms");

	d = TQDir::homeDirPath()+"/.smssend/";

	TQStringList tmp(d.entryList("*.sms"));

	for (TQStringList::Iterator it = tmp.begin(); it != tmp.end(); ++it)
		p.prepend(*it);

	for (TQStringList::iterator it = p.begin(); it != p.end(); ++it)
		(*it).truncate((*it).length()-4);

	prefWidget->provider->insertStringList(p);

	bool found = false;
	if (m_account)
	{	TQString pName = m_account->configGroup()->readEntry("SMSSend:ProviderName", TQString());
		for (int i=0; i < prefWidget->provider->count(); i++)
		{
			if (prefWidget->provider->text(i) == pName)
			{
				found=true;
				prefWidget->provider->setCurrentItem(i);
				setOptions(pName);
				break;
			}
		}
	}
	if (!found)
		setOptions(prefWidget->provider->currentText());
}

void SMSSend::setOptions(const TQString& name)
{
	kdWarning( 14160 ) << k_funcinfo << "m_account = " << m_account << " (should be ok if zero!!)" << endl;
	if(!prefWidget) return;			// sanity check

	prefWidget->providerLabel->setText(i18n("%1 Settings").arg(name));

	labels.setAutoDelete(true);
	labels.clear();
	args.setAutoDelete(true);
	args.clear();

	if (m_provider) delete m_provider;
	m_provider = new SMSSendProvider(name, prefWidget->program->url(), m_account, this);

	for (int i=0; i < m_provider->count(); i++)
	{
		if (!m_provider->name(i).isNull())
		{
			TQLabel *l = new TQLabel(m_parent);
			l->setText("&" + m_provider->name(i) + ":");
			TQToolTip::add(l, m_provider->description(i));
			m_layout->addWidget(l, i+2, 0);
			KLineEdit *e = new KLineEdit(m_parent);
			e->setText(m_provider->value(i));
			m_layout->addWidget(e, i+2, 1);
			args.append(e);
			labels.append(l);
			l->setBuddy(e);
			if(m_provider->isHidden(i))
				e->setEchoMode(TQLineEdit::Password);
			e->show();
			l->show();
		}
	}
}
void SMSSend::setAccount(Kopete::Account* account)
{
	m_provider->setAccount(account);
	SMSService::setAccount(account);
}

int SMSSend::maxSize()
{
	kdWarning( 14160 ) << k_funcinfo << "m_account = " << m_account << " (should be non-zero!!)" << endl;

	TQString pName = m_account->configGroup()->readEntry("SMSSend:ProviderName", TQString());
	if (pName.length() < 1)
		return 160;
	TQString prefix = m_account->configGroup()->readEntry("SMSSend:Prefix", TQString());
	if (prefix.isNull())
		prefix = "/usr";
	// quick sanity check
	if (m_provider) delete m_provider;
	m_provider = new SMSSendProvider(pName, prefix, m_account, this);
	return m_provider->maxSize();
}

const TQString& SMSSend::description()
{
	TQString url = "http://zekiller.skytech.org/smssend_en.php";
	m_description = i18n("<qt>SMSSend is a program for sending SMS through gateways on the web. It can be found on <a href=\"%1\">%2</a></qt>").arg(url).arg(url);
	return m_description;
}


#include "smssend.moc"
/*
 * Local variables:
 * c-indentation-style: k&r
 * c-basic-offset: 8
 * indent-tabs-mode: t
 * End:
 */
// vim: set noet ts=4 sts=4 sw=4:

