/*
    ircservercontact.h - IRC User Contact

    Copyright (c) 2003      by Michel Hermier <michel.hermier@wanadoo.fr>

    Kopete    (c) 2003      by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef IRCSERVERCONTACT_H
#define IRCSERVERCONTACT_H

#include "irccontact.h"

#include "kircengine.h"

#include "kopetechatsessionmanager.h"

#include <tqvaluelist.h>
#include <tqstringlist.h>

class TDEActionCollection;
class TDEAction;
class TDEActionMenu;
class KopeteView;

class IRCContactManager;
class IRCChannelContact;

/**
 * @author Michel Hermier <michel.hermier@wanadoo.fr>
 *
 * This class is the @ref Kopete::Contact object representing IRC Servers.
 * It is derrived from @ref IRCContact where much of its functionality is shared with @ref IRCChannelContact and @ref IRCUserContact.
 */
class IRCServerContact
	: public IRCContact
{
	Q_OBJECT
  

	public:
		// This class provides a Kopete::Contact for each server of a given IRC connection.
		IRCServerContact(IRCContactManager *, const TQString &servername, Kopete::MetaContact *mc);

		virtual const TQString caption() const;

		virtual void appendMessage(Kopete::Message &);
                void appendMessage( const TQString &message );

	protected slots:
		void engineInternalError(KIRC::Engine::Error error, KIRC::Message &ircmsg);
		virtual void slotSendMsg(Kopete::Message &message, Kopete::ChatSession *);

	private slots:
		virtual void updateStatus();
		void slotViewCreated( KopeteView* );
		void slotDumpMessages();

		void slotIncomingUnknown( const TQString &message );
		void slotIncomingConnect( const TQString &message );
		void slotIncomingMotd( const TQString &motd );
		void slotIncomingNotice( const TQString &orig, const TQString &notice );
		void slotCannotSendToChannel( const TQString &channel, const TQString &msg );

	private:
		TQValueList<Kopete::Message> mMsgBuffer;
};

#endif

// vim: set noet ts=4 sts=4 tw=4:

