/***************************************************************************
                          krecconfig_fileswidget.h  -  description
                             -------------------
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#ifndef KREC_CONFIGURE_FILESWIDGET_H
#define KREC_CONFIGURE_FILESWIDGET_H

#include <tqhbox.h>
#include <tqvbox.h>
#include <tqstringlist.h>
#include <tqstring.h>

class TQRadioButton;
class TQCheckBox;
class TQButtonGroup;
class TQLineEdit;
class TQLabel;

class KRecConfigFilesWidget : public TQVBox {
   Q_OBJECT
  
public:
	KRecConfigFilesWidget( TQWidget*, const char* =0 );
	~KRecConfigFilesWidget();

	void load();
	void save();
	void defaults();
signals:
	void sRateChanged( int );
	void sChannelsChanged( int );
	void sBitsChanged( int );
	void sUseDefaultsChanged( bool );
private slots:
	void ratechanged( int );
	void rateotherchanged( const TQString& );
	void channelschanged( int );
	void bitschanged( int );
	void usedefaultschanged( bool );

private:
	TQHBox *_hbox;
	TQButtonGroup *_ratebox, *_channelsbox, *_bitsbox;
	TQRadioButton *_rate48, *_rate44, *_rate22, *_rate11, *_rateother;
	TQHBox *_rateotherbox;
	TQLabel *_rateotherlabel;
	TQLineEdit *_rateotherline;
	TQRadioButton *_channels2, *_channels1;
	TQRadioButton *_bits16, *_bits8;

	TQCheckBox *_usedefaults;

	int _samplingRate, _channels, _bits;
};

#endif

// vim:sw=4:ts=4
