/*

    Copyright ( C ) 2000-2001 Stefan Westerfeld
                              <stefan@space.twc.de>
                    2003 Arnold Krille <arnold@arnoldarts.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    ( at your option ) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#ifndef ARTSCONTROLLIB_FFTSCOPEVIEW_H
#define ARTSCONTROLLIB_FFTSCOPEVIEW_H

#include <artsmodules.h>
#include <flowsystem.h>
#include <kartsserver.h>

#include "templateview.h"

#include <artsgui.h>
#include <tdelibs_export.h>

class TQTimer;
class TDEPopupMenu;
class TDEAction;
class KArtsWidget;
class ArtsActions;

class KDE_EXPORT FFTScopeView : public Template_ArtsView {
   Q_OBJECT
  
protected:
	Arts::StereoFFTScope scopefx;
	Arts::SimpleSoundServer server;
	long effectID;

	std::vector<float> *scopeData;
	std::vector<float> scopeDraw;
	std::vector<Arts::LevelMeter> scopeScales;
	std::vector<KArtsWidget*> aw;
	TQTimer *updatetimer;

	ArtsActions* _artsactions;
	TDEPopupMenu *_menu, *_stylemenu;
	TDEAction *_moreBars, *_lessBars;
	TDEAction *_styleNormalBars, *_styleFireBars, *_styleLineBars, *_styleLEDs, *_styleAnalog, *_styleSmall;
	TDEAction *_substyle;

	void mousePressEvent( TQMouseEvent* );
public:
	void updateScopeData();
	FFTScopeView( Arts::SimpleSoundServer server, TQWidget* =0 );
	~FFTScopeView();

public slots:
	void updateScope();
	void moreBars();
	void lessBars();
	void setStyle( Arts::LevelMeterStyle style );
	void styleNormalBars();
	void styleFireBars();
	void styleLineBars();
	void styleLEDs();
	void styleAnalog();
	void styleSmall();
	void substyle();
};

// vim: sw=4 ts=4
#endif
