/*
    Copyright ( C ) 2002, 2003 Arnold Krille <arnold@arnoldarts.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or ( at your option ) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#include "klayoutbox_impl.h"

#include <tqframe.h>
#include <tqlayout.h>
#include <kdebug.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqpen.h>
#include "kwidgetrepo.h"

using namespace Arts;
using namespace std;

KLayoutBox_impl::KLayoutBox_impl( TQFrame *widget ) : KFrame_impl( widget ? widget :new TQFrame( 0 ) )
{
	_qframe = static_cast<TQFrame*>( _qwidget );
	_layout = new TQBoxLayout( _qframe, TQBoxLayout::LeftToRight );
}
KLayoutBox_impl::~KLayoutBox_impl() {
}

void KLayoutBox_impl::addWidget( Arts::Widget widget, long stretch, long align ) {
	widget.parent( self() );
	this->_addChild( widget, "layoutbox_item" );
	TQWidget * tmp = KWidgetRepo::the()->lookupTQWidget( widget.widgetID() );
	_layout->addWidget( tmp, stretch, align );
}

void KLayoutBox_impl::insertWidget( long index, Arts::Widget widget, long stretch, long align ) {
	widget.parent( self() );
	this->_addChild( widget, "layoutbox_item" );
	TQWidget * tmp = KWidgetRepo::the()->lookupTQWidget( widget.widgetID() );
	_layout->insertWidget( index, tmp, stretch, align );
}

void KLayoutBox_impl::addStretch( long n ) { _layout->addStretch( n ); }
void KLayoutBox_impl::addSpace( long n ) { _layout->addSpacing( n ); }
void KLayoutBox_impl::addStrut( long n ) { _layout->addStrut( n ); }
void KLayoutBox_impl::addSeparator( long stretch, long align ) {
	_layout->addWidget( new KLayoutBox_Separator( _qframe ), stretch, align );
}
void KLayoutBox_impl::addLine( long width, long space, long stretch, long align ) {
	_layout->addWidget( new KLayoutBox_Line( width, space, _qframe ), stretch, align );
}

long KLayoutBox_impl::spacing() { return _layout->spacing(); }
void KLayoutBox_impl::spacing( long n ) { _layout->setSpacing( n ); }

long KLayoutBox_impl::layoutmargin() { return _layout->margin(); }
void KLayoutBox_impl::layoutmargin( long n ) { _layout->setMargin( n ); this->margin( n ); }

Direction KLayoutBox_impl::direction() { return Arts::Direction( _layout->direction() ); }
void KLayoutBox_impl::direction( Direction d ) { _layout->setDirection( TQBoxLayout::Direction( d ) ); }

REGISTER_IMPLEMENTATION( KLayoutBox_impl );

KLayoutBox_Separator::KLayoutBox_Separator( TQWidget* p, const char* n ) : TQWidget( p,n ) {
//kdDebug() << k_funcinfo << endl;
}

void KLayoutBox_Separator::resizeEvent( TQResizeEvent* ) { kdDebug() << k_funcinfo << size() << endl; }

void KLayoutBox_Separator::paintEvent( TQPaintEvent* ) {
//kdDebug() << k_funcinfo << size() << endl;
	TQPainter p( this );
	TQStyle::SFlags flags = TQStyle::Style_Default;
	if ( width() < height() ) flags |= TQStyle::Style_Horizontal;
	style().tqdrawPrimitive( TQStyle::PE_Splitter, &p, rect(), colorGroup(), flags );
}

TQSize KLayoutBox_Separator::minimumSizeHint() const {
	int wh = style().pixelMetric( TQStyle::PM_SplitterWidth, this );
	return TQSize( wh, wh );
}

KLayoutBox_Line::KLayoutBox_Line( int width, int space, TQWidget* p, const char* n )
  : TQWidget( p,n )
  , _width( width )
  , _space( space )
{
//kdDebug() << k_funcinfo << size() << endl;
}


void KLayoutBox_Line::paintEvent( TQPaintEvent* ) {
//kdDebug() << k_funcinfo << size() << endl;
	TQPainter p( this );
	p.setPen( TQPen( colorGroup().foreground(), _width ) );
	if ( width() > height() ) p.drawLine( 0, height()/2, width(), height()/2 );
		else p.drawLine( width()/2, 0, width()/2, height() );
}

TQSize KLayoutBox_Line::minimumSizeHint() const {
//kdDebug() << k_funcinfo << size() << endl;
	int wh = _width + 2* _space;
	return TQSize( wh, wh );
}

#include <klayoutbox_impl.moc>

// vim: sw=4 ts=4

