/* This file is part of the KDE libraries
   Copyright (C) 2001 Christoph Cullmann <cullmann@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>
   Copyright (C) 1999 Jochen Wilhelmy <digisnap@cs.tu-berlin.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "katedocumenthelpers.h"
#include "katedocumenthelpers.moc"

#include "katedocument.h"
#include "kateview.h"

#include <tdepopupmenu.h>
#include <tdelocale.h>

KateBrowserExtension::KateBrowserExtension( KateDocument* doc )
: KParts::BrowserExtension( doc, "katepartbrowserextension" ),
  m_doc (doc)
{
  connect( doc, TQT_SIGNAL( selectionChanged() ),
           this, TQT_SLOT( slotSelectionChanged() ) );
  emit enableAction( "print", true );
}

void KateBrowserExtension::copy()
{
  if (m_doc->activeView())
    m_doc->activeView()->copy();
}

void KateBrowserExtension::print()
{
  m_doc->printDialog();
}

void KateBrowserExtension::slotSelectionChanged()
{
  if (m_doc->activeView())
    emit enableAction( "copy", m_doc->activeView()->hasSelection() );
}

// kate: space-indent on; indent-width 2; replace-tabs on;
