#ifndef FLOATER_H
#define FLOATER_H

#include "game.h"

class Floater;
class FloaterConfig : public BridgeConfig
{
	Q_OBJECT
  

public:
	FloaterConfig(Floater *floater, TQWidget *parent);

private slots:
	void speedChanged(int news);

private:
	Floater *floater;
};

class FloaterGuide : public Wall
{
public:
	FloaterGuide(Floater *floater, TQCanvas *canvas) : Wall(canvas) { this->floater = floater; almostDead = false; }
	virtual void setPoints(int xa, int ya, int xb, int yb);
	virtual void moveBy(double dx, double dy);
	virtual Config *config(TQWidget *parent);
	virtual void aboutToDelete();
	virtual void aboutToDie();

private:
	Floater *floater;
	bool almostDead;
};

class Floater : public Bridge
{
public:
	Floater(TQRect rect, TQCanvas *canvas);
	virtual bool collision(Ball *ball, long int id) { Bridge::collision(ball, id); return false; }
	virtual void saveState(StateDB *db);
	virtual void loadState(StateDB *db);
	virtual void save(TDEConfig *cfg);
	virtual void load(TDEConfig *cfg);
	virtual bool loadLast() const { return true; }
	virtual void firstMove(int x, int y);
	virtual void aboutToSave();
	virtual void aboutToDie();
	virtual void savingDone();
	virtual void setGame(KolfGame *game);
	virtual void editModeChanged(bool changed);
	virtual bool moveable() const { return false; }
	virtual void moveBy(double dx, double dy);
	virtual Config *config(TQWidget *parent) { return new FloaterConfig(this, parent); }
	virtual TQPtrList<TQCanvasItem> moveableItems() const;
	virtual void advance(int phase);
	void setSpeed(int news);
	int curSpeed() const { return speed; }

	// called by floaterguide when changed;
	void reset();

private:
	int speedfactor;
	int speed;
	FloaterGuide *wall;
	TQPoint origin;
	Vector vector;
	bool noUpdateZ;
	bool haventMoved;
	TQPoint firstPoint;
};

class FloaterObj : public Object
{
public:
	FloaterObj() { m_name = i18n("Floater"); m__name = "floater"; }
	virtual TQCanvasItem *newObject(TQCanvas *canvas) { return new Floater(TQRect(0, 0, 80, 40), canvas); }
};

#endif
