/*
   Copyright (C) 2000, 2001, 2002 Dawit Alemayehu <adawit@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>

#define HAVE_TERMIOS_H 1
#define HAVE_GRANTPT 1

#include <stdlib.h>
#ifdef HAVE_PTY_H
#include <pty.h>
#endif
#ifdef HAVE_TERMIOS_H
#include <termios.h>
#endif
#ifdef HAVE_STROPTS
#include <stropts.h>
#endif
#ifdef HAVE_SYS_IOCTL_H
#include <sys/ioctl.h>
#endif
#ifdef HAVE_LIBUTIL_H
#include <libutil.h>
#endif
#ifdef HAVE_UTIL_H
#include <util.h>
#endif

#include <tqfile.h>
#include <tqtimer.h>
#include <tqapplication.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqhbox.h>
#include <tqwhatsthis.h>
#include <tqiconview.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqstring.h>
#include <tqregexp.h>
#include <tqstyle.h>
#include <tqtimer.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <kinstance.h>

#include <twin.h>
#include <kurl.h>
#include <tdeaction.h>
#include <tdepopupmenu.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <kprogressbox.h>
#include <kpassdlg.h>
#include <tdelistview.h>
#include <tdeapplication.h>
#include <tdeconfigdialog.h>

#include <kdirlister.h>
#include <kstandarddirs.h>
#include <tdelistviewsearchline.h>
#include <kiconviewsearchline.h>
#include <konq_dirpart.h>
#include <konq_propsview.h>
#include <kstaticdeleter.h>
#include <kgenericfactory.h>
#include <tdeparts/browserextension.h>

#include <tdeio/global.h>
#include <tdeio/slavebase.h>

#include "rsyncplugin.h"

#define myDebug(x) kdDebug(7127) << __LINE__ << ": " x

#define CONFIGURATION_FILE_SEPARATOR ';'

typedef KGenericFactory<RsyncPlugin> RsyncPluginFactory;
K_EXPORT_COMPONENT_FACTORY(librsyncplugin,
                           RsyncPluginFactory("rsyncplugin"))

RsyncPlugin::RsyncPlugin (TQObject* parent, const char* name,
                                  const TQStringList&)
                :KParts::Plugin (parent, name),
                m_pSyncNow(0),
                m_pSyncSetup(0)
{
  m_part = ::tqqt_cast<KonqDirPart*>(parent);

  if ( !m_part || !m_part->scrollWidget() )
    return;

  m_pSyncNow = new TDEAction(i18n("Synchronize F&older"), "syncnow",
                               actionCollection(), "syncnow");
  m_pSyncSetup = new TDEAction (i18n("Setup Syn&chronization"), "setupsync",
                               actionCollection(), "setupsync");
  m_pSyncNow->setIcon("remotesync");
  m_pSyncSetup->setIcon("remotesyncconfig");
  m_pSyncNow->setEnabled (false);

  m_rSync = new KRsync(parent, name);

  connect (m_part, TQT_SIGNAL(aboutToOpenURL()), TQT_SLOT(slotOpenURL()));

  connect(m_pSyncNow, TQT_SIGNAL(activated()), this, TQT_SLOT(slotSync()));
  connect(m_pSyncSetup, TQT_SIGNAL(activated()), this, TQT_SLOT(slotSetup()));

  connect(m_rSync, TQT_SIGNAL(setupDone()), this, TQT_SLOT(slotSetupDone()));
  connect(m_rSync, TQT_SIGNAL(transferDone()), this, TQT_SLOT(slotTransferDone()));

  m_rSync->loadSettings();
}

RsyncPlugin::~RsyncPlugin()
{
  delete m_pSyncNow;
  delete m_pSyncSetup;
}

// --------------------------------------------------------------------------------------------
//
// Here begins the standard load/save/search/Konqy stuff
//
// --------------------------------------------------------------------------------------------

void RsyncPlugin::slotOpenURL ()
{
  KURL url = m_part->url();
  m_rSync->setCurrentDirectoryURL(url);

  if (m_pURL != url)
  {
	// See if this URL is "/", "/dev", or "/proc", and disable sync if so
	// Also disable sync for non-"file://" URLs
	if ((url.directory(true, true) + TQString("/") + url.fileName(true)) == "//") {
		m_pSyncSetup->setEnabled(false);
		m_pSyncNow->setEnabled(false);
	}
	else if (((url.directory(true, true) + TQString("/") + url.fileName(true)).left(5) == "//dev") || ((url.directory(true, true) + TQString("/") + url.fileName(true)).left(4) == "/dev")) {
		m_pSyncSetup->setEnabled(false);
		m_pSyncNow->setEnabled(false);
	}
	else if (((url.directory(true, true) + TQString("/") + url.fileName(true)).left(6) == "//proc") || ((url.directory(true, true) + TQString("/") + url.fileName(true)).left(5) == "/proc")) {
		m_pSyncSetup->setEnabled(false);
		m_pSyncNow->setEnabled(false);
	}
	else if (url.protocol() != TQString("file")) {
		m_pSyncSetup->setEnabled(false);
		m_pSyncNow->setEnabled(false);
	}
	else {
		m_pSyncSetup->setEnabled(true);

		// See if this URL is in the list of rsync-able directories
		if (m_rSync->findLocalFolderByName(url.directory(true, true) + TQString("/") + url.fileName(true)) != NULL) {
			m_pSyncNow->setEnabled (true);
		}
		else {
			m_pSyncNow->setEnabled (false);
		}
	}
  }
  m_pURL = url;
}

void RsyncPlugin::slotSetup()
{
	KURL url = m_part->url();
	m_rSync->setCurrentDirectoryURL(url);

	m_pSyncSetup->setEnabled (false);
	m_rSync->slotSetup();
}

void RsyncPlugin::slotSetupDone()
{
	m_pSyncSetup->setEnabled (true);
}

void RsyncPlugin::slotTransferDone()
{
	m_pSyncNow->setEnabled (true);
}

void RsyncPlugin::slotSync()
{
	if (!m_part)
		return;

	KURL url = m_part->url();
	m_rSync->setCurrentDirectoryURL(url);

	m_rSync->slotSync();
}

#include "rsyncplugin.moc"
