/***************************************************************************
                             domlistviewitem.cpp
                             -------------------

    author               : Andreas Schlapbach
    email                : schlpbch@iam.unibe.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "domlistviewitem.h"

#include <tqpainter.h>
#include <tqlistview.h>
#include <tqapplication.h>

#include <tdeglobalsettings.h>

DOMListViewItem::DOMListViewItem( const DOM::Node &node, TQListView *parent )
  : TQListViewItem( parent ), m_node(node)
{
  init();
}

DOMListViewItem::DOMListViewItem( const DOM::Node &node, TQListView *parent, TQListViewItem *after)
  : TQListViewItem( parent, after ), m_node(node)
{
  init();
}

DOMListViewItem::DOMListViewItem( const DOM::Node &node, TQListViewItem *parent )
  : TQListViewItem( parent ), m_node(node)
{
  init();
}

DOMListViewItem::DOMListViewItem( const DOM::Node &node, TQListViewItem *parent, TQListViewItem *after)
  : TQListViewItem( parent, after ), m_node(node)
{
  init();
}

DOMListViewItem::~DOMListViewItem()
{
  //NOP
}

void DOMListViewItem::init()
{
  m_color = TQApplication::palette().color( TQPalette::Active, TQColorGroup::Text );
  m_font = TDEGlobalSettings::generalFont();
  clos = false;
}

void DOMListViewItem::paintCell( TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment )
{
  TQColorGroup _cg( cg );
  TQColor c = _cg.text();

  p->setFont(m_font);
  _cg.setColor( TQColorGroup::Text, m_color );
  TQListViewItem::paintCell( p, _cg, column, width, alignment );
  _cg.setColor( TQColorGroup::Text, c );
}


