/* This file is part of Kolourpicker
   Copyright (c) 2001 Malte Starostik <malte@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

*/

#ifndef _KOLOURPICKER_H_
#define _KOLOURPICKER_H_

#include <tqmap.h>
#include <tqvaluelist.h>

#include <kpanelapplet.h>

#include "simplebutton.h"

class TDEInstance;
class TQPopupMenu;

class KolourPicker : public KPanelApplet
{
	Q_OBJECT
  
public:
	KolourPicker(const TQString& configFile, Type t = Normal, int actions = 0,
		TQWidget *parent = 0, const char *name = 0);
    ~KolourPicker();
	virtual int heightForWidth(int) const;
	virtual int widthForHeight(int) const;
	virtual void about();

protected:
	virtual void mouseReleaseEvent(TQMouseEvent *);
	virtual void keyPressEvent(TQKeyEvent *);
	virtual void resizeEvent(TQResizeEvent*);

private slots:
	void slotPick();
	void slotHistory();

private:
	TQPopupMenu *copyPopup(const TQColor &, bool title) const;
	TQPixmap colorPixmap(const TQColor &) const;
	const TQStringList &colorNames(int r, int g, int b) const;
	void arrangeButtons();
	void setClipboard(const TQString& text);

	TDEInstance *m_instance;
	bool m_picking;
	SimpleButton *m_historyButton, *m_colourButton;
	TQValueList<TQColor> m_history;
	TQMap<int, TQStringList> m_colorNames;
};

#endif

// vim: ts=4 sw=4 noet
