from python_tqt.qt import TQFrame, TQHBoxLayout, TQVBoxLayout, SIGNAL
from tdecore import i18n
from tdeui import KPushButton, KPasswordDialog, KTextEdit

iconName = 'password'
labelText = 'KPasswordDialog'
docParts = ('tdeui', 'KPasswordDialog')
helpText = ("KDE provides two variations on the password dialog.  The simple "
            "one shown here prompts for a password.  The other type allows the "
            "user to enter a new password, and provides a second field to "
            "confirm the first entry.")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Password Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showPasswordDialog)


    def showPasswordDialog(self):
        old = 'foo bar baz'
        prompt = "Enter your super-secret password (enter anything, it's just an example):"
        result = KPasswordDialog.getPassword(old, prompt)
        if result == KPasswordDialog.Accepted:
            pass

