/**********************************************************************
**   Copyright (C) 2000 Troll Tech AS.  All rights reserved.
**   Copyright (C) 2000, 2001 Phil Thompson <phil@river-bank.demon.co.uk>
**
**   This file is part of TQt GUI Designer.
**
**   This file may be distributed under the terms of the GNU General
**   Public License version 2 as published by the Free Software
**   Foundation and appearing in the file COPYING included in the
**   packaging of this file. If you did not get the file, send email
**   to info@trolltech.com
**
**   The file is provided AS IS with NO WARRANTY OF ANY KIND,
**   INCLUDING THE WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR
**   A PARTICULAR PURPOSE.
**
**********************************************************************/

#ifndef DOMTOOL_H
#define DOMTOOL_H

#include <tqnamespace.h>
#include <tqvariant.h>
#include <tqdom.h>


class DomTool : public TQt
{
public:
    static TQVariant readProperty( const TQDomElement& e, const TQString& name, const TQVariant& defValue );
    static bool hasProperty( const TQDomElement& e, const TQString& name );
    static TQVariant elementToVariant( const TQDomElement& e, const TQVariant& defValue );
    static TQVariant elementToVariant( const TQDomElement& e, const TQVariant& defValue, TQString &comment );
    static TQVariant readAttribute( const TQDomElement& e, const TQString& name, const TQVariant& defValue );
    static bool hasAttribute( const TQDomElement& e, const TQString& name );
    static TQColor readColor( const TQDomElement &e );

};


#endif // DOMTOOL_H
