#!/usr/bin/env python

# TQt tutorial 9.

import sys
from python_tqt.qt import *


class LCDRange(TQVBox):
    def __init__(self,parent=None,name=None):
        TQVBox.__init__(self,parent,name)

        lcd = TQLCDNumber(2,self,'lcd')
        self.slider = TQSlider(TQt.Horizontal,self,'slider')
        self.slider.setRange(0,99)
        self.slider.setValue(0)
        self.connect(self.slider,SIGNAL('valueChanged(int)'),lcd,SLOT('display(int)'))
        self.connect(self.slider,SIGNAL('valueChanged(int)'),self,PYSIGNAL('valueChanged(int)'))

        self.setFocusProxy(self.slider)

    def value(self):
        return self.slider.value()

    def setValue(self,value):
        self.slider.setValue(value)

    def setRange(self,minVal,maxVal):
        if minVal < 0 or maxVal > 99 or minVal > maxVal:
            raise ValueError, 'LCDRange.setRange(): invalid range'
        self.slider.setRange(minVal,maxVal)


class CannonField(TQWidget):
    def __init__(self,parent=None,name=None):
        TQWidget.__init__(self,parent,name)

        self.ang = 45
        self.setPalette(TQPalette(TQColor(250,250,200)))

    def angle(self):
        return self.ang

    def setAngle(self,degrees):
        if degrees < 5:
            degrees = 5
        if degrees > 70:
            degrees = 70
        if self.ang == degrees:
            return
        self.ang = degrees
        self.repaint()
        self.emit(PYSIGNAL('angleChanged(int)'),(self.ang,))

    def paintEvent(self,ev):
        p = TQPainter(self)

        p.setBrush(TQt.blue)
        p.setPen(TQt.NoPen)

        p.translate(0,self.rect().bottom())
        p.drawPie(TQRect(-35,-35,70,70),0,90 * 16)
        p.rotate(-self.ang)
        p.drawRect(TQRect(33,-4,15,8))

    def sizePolicy(self):
        return TQSizePolicy(TQSizePolicy.Expanding,TQSizePolicy.Expanding)


class MyWidget(TQWidget):
    def __init__(self,parent=None,name=None):
        TQWidget.__init__(self,parent,name)

        quit = TQPushButton('&Quit',self,'quit')
        quit.setFont(TQFont('Times',18,TQFont.Bold))
        self.connect(quit,SIGNAL('clicked()'),tqApp,SLOT('quit()'))

        self.angle = LCDRange(self,'angle')
        self.angle.setRange(5,70)

        self.cannonField = CannonField(self,'cannonField')

        self.connect(self.angle,PYSIGNAL('valueChanged(int)'),self.cannonField.setAngle)
        self.connect(self.cannonField,PYSIGNAL('angleChanged(int)'),self.angle.setValue)

        grid = TQGridLayout(self,2,2,10)

        grid.addWidget(quit,0,0)
        grid.addWidget(self.angle,1,0,TQt.AlignTop)
        grid.addWidget(self.cannonField,1,1)
        grid.setColStretch(1,10)

        self.angle.setValue(60)
        self.angle.setFocus()


TQApplication.setColorSpec(TQApplication.CustomColor)
a = TQApplication(sys.argv)

w = MyWidget()
w.setGeometry(100,100,500,355)
a.setMainWidget(w)
w.show()
a.exec_loop()
