/***************************************************************************
 *
 * tdenetman-wired_device_tray.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// TQt includes
#include <tqevent.h>
#include <tqvbox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tqbitmap.h>
#include <tqimage.h>
#include <tqpixmap.h>
#include <tqpixmapcache.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqstring.h>

// TDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <kiconloader.h>

// TDENM includes
#include "tdenetman-wired_device_tray.h"
#include "tdenetman-menuitem.h"
#include "tdenetman-menu_subhead.h"

#include "tdenetman-connection_settings_dialog.h"

using namespace ConnectionSettings;

class WiredDeviceTrayPrivate
{
	public:
		WiredDeviceTrayPrivate() {}
		~WiredDeviceTrayPrivate() {}

		TQString dev;
};

void WiredDeviceTray::newConnection()
{
	TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();

	// create a new wired connection
	TDENetworkConnection* conn = new TDEWiredEthernetConnection();
	nm->loadConnectionAllowedValues(conn);

	// edit the new connection
	ConnectionSettingsDialogImpl* dlg = new ConnectionSettingsDialogImpl(conn, true, TQByteArray(), tray(), "connect_something", false, TQt::WDestructiveClose);
	dlg->show();
}


void WiredDeviceTray::addMenuItems(TDEPopupMenu* menu)
{
	TDENetworkDevice* dev = dynamic_cast<TDENetworkDevice*>(hwdevices->findByUniqueID(d->dev));

	// device title
	Subhead* subhead = new Subhead (menu, "subhead", TQString("Wired Connection (%1)").arg(dev->deviceNode()), SmallIcon("wired", TQIconSet::Automatic));
	menu->insertItem (subhead, -1, -1);

	// bolding subhead instead
	//menu->insertSeparator();

	TDENetworkConnectionManager* deviceConnMan = dev->connectionManager();
	if (deviceConnMan->deviceInformation().statusFlags & TDENetworkConnectionStatus::LinkUnavailable) {
		// no carrier -> do not show any connections
		subhead = new Subhead(menu, "subhead2", i18n("Cable disconnected"), SmallIcon("no", TQIconSet::Automatic));
		menu->insertItem(subhead, -1, -1);
	}
	else {
		TDEGlobalNetworkManager* nm = TDEGlobal::networkManager();
		TDENetworkConnectionManager* deviceConnMan = dev->connectionManager();
		TDENetworkConnection* active_conn = NULL;
		if ((!(deviceConnMan->deviceInformation().statusFlags & TDENetworkConnectionStatus::Disconnected))
			&& (!(deviceConnMan->deviceInformation().statusFlags & TDENetworkConnectionStatus::Invalid))) {
			active_conn = nm->findConnectionByUUID(deviceConnMan->deviceInformation().activeConnectionUUID);
		}

		// get all available Connections for wired devices
		TDENetworkConnectionList* connections = nm->connections();
		int connectionItems = 0;
		for (TDENetworkConnectionList::Iterator it = connections->begin(); it != connections->end(); ++it) {
			TDEWiredEthernetConnection* conn = dynamic_cast<TDEWiredEthernetConnection*>(*it);
			if (!conn) {
				continue;
			}

			// wired connection found :)
			// lets create a nice name for this connection
			TQString title = conn->friendlyName;
			if (conn->ipConfig.valid) {
				title += TQString(" (%1)").arg((conn->ipConfig.connectionFlags & TDENetworkIPConfigurationFlags::IPV4DHCPIP) ? i18n("DHCP") : i18n("Manual IP config"));
			}

			NetworkMenuItem* item = new NetworkMenuItem(d->dev, conn->UUID, TQT_TQOBJECT(menu));
			connectionItems += 1;

			int id = menu->insertItem(title, item, TQT_SLOT(slotActivate()));
			menu->setItemChecked(id, ((*it) == active_conn));
		}

		if ( connectionItems == 0) {
			// menu->insertSeparator();
			menu->insertItem(SmallIcon("document-new", TQIconSet::Automatic), i18n("Create new wired connection"), this, TQT_SLOT(newConnection()));
		}

		// bring the device down
		TDEAction* deactivate = tray()->actionCollection()->action("deactivate_device");
		if (deactivate) {
			deactivate->plug(menu);
		}

	}
}

WiredDeviceTray::WiredDeviceTray (TQString dev, KSystemTray * parent, const char * name )
	: DeviceTrayComponent (dev, parent, name)
{
	hwdevices = TDEGlobal::hardwareDevices();
	d = new WiredDeviceTrayPrivate();
	d->dev = dev;

	setPixmapForState(TDENetworkConnectionStatus::Connected, "nm_device_wired");
}

WiredDeviceTray::~WiredDeviceTray ()
{
	delete d;
}

#include "tdenetman-wired_device_tray.moc"
