/***************************************************************************
 *
 * tdenetman-connection_setting_vpn_widget.cpp - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 * Author: Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// tqt headers
#include <tqwidget.h>
#include <tqlineedit.h>
#include <tqcheckbox.h>
#include <tqlayout.h>
#include <tqcombobox.h>
#include <tqiconset.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <tqwidgetstack.h>
#include <kuser.h>

// tdenm headers
#include "tdenetman-connection_setting_vpn_widget.h"
#include "tdenetman-vpnmanager.h"
#include "tdenetman-vpnservice.h"

using namespace ConnectionSettings;

VPNWidgetImpl::VPNWidgetImpl(TDENetworkConnection* conn, bool new_conn, TQWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
	, _new_conn(new_conn)
{
	_vpnsetting = dynamic_cast<TDEVPNConnection*>(conn);
	_parentdialog = dynamic_cast<ConnectionSettingsDialogImpl*>(parent);

	TQVBoxLayout* layout = new TQVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingVPNWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
VPNWidgetImpl::Init()
{
	// fill in all possible VPN services
	VPNServiceList list = VPNManager::getVPNServices();

	if (list.isEmpty()) {
		if (_parentdialog) {
			_parentdialog->_disable_next_button = true;
			_parentdialog->slotEnableButtons();
		}
	}
	else {
		int index = 0;
		for (VPNServiceList::Iterator it = list.begin(); it != list.end(); ++it) {
			TQString icon;
			TQString disp_name;

			// get service icon and display name
			VPNService* service = *it;
			if (service) {
				icon = service->getIcon();
				disp_name = service->getDisplayName();
			}

			if (strcmp(disp_name, "vpnc") == 0) {
				disp_name = "Cisco VPN";
			}
			else if (strcmp(disp_name, "pptp") == 0) {
				disp_name = "Microsoft PPTP VPN";
			}
			else if (strcmp(disp_name, "openvpn") == 0) {
				disp_name = "Open VPN";
			}
			else if (strcmp(disp_name, "strongswan") == 0) {
				disp_name = "StrongSwan VPN";
			}

			// the service should not be changed when editing a connection
			if (service->getService() != _vpnsetting->vpnPluginID && !_new_conn) {
				continue;
			}

			// no special icon for this service, use default
			if (icon.isEmpty()) {
				icon = "encrypted";
			}

			_mainWid->cboServices->insertItem(SmallIcon(icon, TQIconSet::Automatic), disp_name, index);
			_mapServiceCombo.insert(index++, *it);

			if (service->getService() == _vpnsetting->vpnPluginID) {
				// preselect the correct service
				_mainWid->cboServices->setCurrentItem(index - 1);
				slotServiceComboActivated(index - 1);
			}
		}
		if (_parentdialog) {
			_parentdialog->_disable_next_button = false;
			_parentdialog->slotEnableButtons();
		}
	}

	// lock the combo when editing an already existing connection
	if (!_new_conn) {
		_mainWid->cboServices->setEnabled(false);
	}
	else {
		// preselect the correct service
		_mainWid->cboServices->setCurrentItem(0);
		slotServiceComboActivated(0);
	}

#if 0
	// update the username to the current one
	KUser user;
	_vpnsetting->lockedUserName = user.loginName();
#else
	// Not needed for NM 0.9 and above?
	_vpnsetting->lockedUserName = TQString::null;
#endif

	// notification if VPN service is selected
	connect(_mainWid->cboServices, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotServiceComboActivated(int)));
}

VPNConfigWidget*
VPNWidgetImpl::getVPNConfigWidget(VPNService* service)
{
	if (_mapServiceWidget.find(service) != _mapServiceWidget.end()) {
		// return the already available config widget
		return *_mapServiceWidget.find(service);
	}
	else {
		// we have to create a new one
		VPNPlugin* plugin = service->getVPNPlugin();
		if (plugin) {
			VPNConfigWidget* config = plugin->CreateConfigWidget(_mainWid->widgetStack);
			_mapServiceWidget.insert(service, config);
			return config;
		}
	}
	return NULL;
}


void
VPNWidgetImpl::slotServiceComboActivated(int index)
{
	VPNService* service;
	if (_mapServiceCombo.find(index) != _mapServiceCombo.end()) {
		service = *_mapServiceCombo.find(index);
		if (service) {
			VPNConfigWidget* config = getVPNConfigWidget(service);
			_mainWid->widgetStack->raiseWidget(config);

			config->setVPNData(_vpnsetting->ipConfig.routeConfigurations, _vpnsetting->pluginData, _vpnsetting->pluginSecrets);
		}
	}
	else {
		//FIXME - do something useful here
	}
}

void
VPNWidgetImpl::Deactivate()
{
	// update the setting from the currently selected vpn service
	VPNService* service = *_mapServiceCombo.find(_mainWid->cboServices->currentItem());
	if (service) {
		// set the correct service type
		_vpnsetting->vpnPluginID = service->getService();

		if (_mapServiceWidget.find(service) != _mapServiceWidget.end()) {
			VPNConfigWidget* config = *_mapServiceWidget.find(service);
			if (config) {
				// update the vpn properties
				_vpnsetting->pluginData = config->getVPNProperties();
				// update the vpn secrets
				_vpnsetting->pluginSecrets = config->getVPNSecrets();
			}
		}
	}
}

void
VPNWidgetImpl::Activate()
{

}

#include "tdenetman-connection_setting_vpn_widget.moc"
