#!/bin/sh

# Modified by Tobi Vollebregt for use with tdeio-locate.

# Inspired by Makefile.common from coolo
# this script is used to update the .po files

# To update the translations, you will need a specific gettext
# patched for kde and a lot of patience, tenacity, luck, time ..


# I guess one should only update the .po files when all .cpp files
# are generated (after a make or scons)

# If you have a better way to do this, do not keep that info
# for yourself and help me to improve this script, thanks
# (tnagyemail-mail tat yahoo d0tt fr)
#

SRCDIR=../src
TIPSDIR=$SRCDIR/appdata

TDEDIR=`tde-config --prefix`
EXTRACTRC=extractrc
KDEPOT=`tde-config --prefix`/include/tde/kde.pot
XGETTEXT="xgettext -C -ki18n -ktr2i18n -kI18N_NOOP -ktranslate -kaliasLocale -x $KDEPOT "

## check that kde.pot is available
if ! test -e $KDEPOT; then
	echo "$KDEPOT does not exist, there may be something wrong with your installation!"
	XGETTEXT="xgettext -C -ki18n -ktr2i18n -kI18N_NOOP -ktranslate -kaliasLocale "
fi

## extract the strings
echo "extracting the strings"

echo -e 'i18n("_: NAME OF TRANSLATORS\\n"\n"Your names")\ni18n("_: EMAIL OF TRANSLATORS\\n"\n"Your emails")' > $SRCDIR/_translatorinfo.cpp

## bad hack to get strings from *.ui files
# Armin Straub <linux@arminstraub.de>
UIC="uic -tr i18n"
TMPHACK="$SRCDIR/tmphack"
mkdir $TMPHACK || exit 1
for F in "$SRCDIR/"*.ui; do
    echo ".. preparing $F"
    FN=$TMPHACK/$(basename "$F")
    $UIC "$F" > "$FN.h" && $UIC -impl "$FN.h" "$F" > "$FN.cpp"
done
tdeconfig_compiler -d $TMPHACK $SRCDIR/*.kcfg $SRCDIR/*.kcfgc
## bad hack to get strings from *.ui files

$XGETTEXT `find $SRCDIR -name "*.cpp"` -o tdeio_locate.pot

## bad hack to get strings from *.ui files
rm -rf "$TMPHACK"
## bad hack to get strings from *.ui files

# remove the intermediate files
rm -f $SRCDIR/_translatorinfo.cpp

## now merge the .po files ..
echo "merging the .po files"

for i in `ls *.po`; do
	msgmerge $i tdeio_locate.pot -o $i || exit 1
done

## finished
echo "Done"
