

#ifndef FORMATINFOLOADER_H
#define FORMATINFOLOADER_H

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqdom.h>

/**
 * @short The complete information about that format
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class FormatInfo
{
public:
    /**
     * Constructor
     */
    FormatInfo();

    /**
     * Destructor
     */
    virtual ~FormatInfo();

    TQStringList mime_types;
    TQStringList extensions;
    TQString description;
    TQStringList urls;
    enum CompressionType {
        lossy             = 0x0001, // encode with loss
        lossless          = 0x0002, // encode without loss
        hybrid            = 0x0004  // encode a file with loss and a correction file
    } compressionType;
    int size;
};

/**
 * @short The format info loader that provides information about the compression type and a format description
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class FormatInfoLoader : public TQObject
{
    Q_OBJECT
  
public:
    /**
     * Constructor
     */
    FormatInfoLoader();

    /**
     * Destructor
     */
    virtual ~FormatInfoLoader();

    /** is this file a converter plugin and loadable? */
    bool verifyFile( TQString );
    /** load a given file */
    FormatInfo* loadFile( TQString );
    /** the dom tree for loading the xml file */
    TQDomDocument domTree;
};

#endif // FORMATINFOLOADER_H
