/***************************************************************************
    smb4ksharesiconviewtooltip  -  Tool tip for the shares icon view.
                             -------------------
    begin                : Do Jan 4 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESICONVIEWTOOLTIP_H
#define SMB4KSHARESICONVIEWTOOLTIP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqlabel.h>
#include <tqpoint.h>
#include <tqlayout.h>

// Forward declarations:
class Smb4KSharesIconViewItem;

/**
 * This class provides the tool tip for the shares icon view
 * of Smb4K. It shows information about the associated share.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesIconViewToolTip : public TQLabel
{
  Q_OBJECT
  

  public:
    /**
     * The constructor.
     *
     * Please note that the parent of the tool tip will be '0' and
     * not the parent widget of @p item. Thus, you have to delete the
     * tool tip object in the destructor of the parent widget.
     *
     * @param item        The item for which the tool tip should be shown.
     */
    Smb4KSharesIconViewToolTip( Smb4KSharesIconViewItem *item );

    /**
     * The destructor
     */
    ~Smb4KSharesIconViewToolTip();

    /**
     * Show the tool tip. Please note that the tool tip will not be
     * shown exactly at position @p pos but with a displacement of 5
     * pixels in x- and y-direction.
     *
     * @param pos         The global position of the mouse pointer.
     */
    void showTip( const TQPoint &pos );

    /**
     * The shares icon view item for which the tool tip should be shown.
     *
     * @returns a pointer to a Smb4KSharesIconViewItem object.
     */
    Smb4KSharesIconViewItem *item() { return m_item; }

    /**
     * Update the tool tip by rereading the contents of the shareObject()
     * provided by the Smb4KSharesIconViewItem. This function only changes
     * those entries that might have changed such as the free and used disk
     * space and the usage.
     */
    void update();

  protected:
    /**
     * Reimplemented from TQLabel.
     */
    void mousePressEvent( TQMouseEvent *e );

    /**
     * Reimplemented from TQLabel.
     */
    void leaveEvent( TQEvent *e );

  protected slots:
    /**
     * This slot hides the tool tip after 10 sec.
     */
    void slotHideToolTip();

  private:
    /**
     * The item for which the tool tip should be shown
     */
    Smb4KSharesIconViewItem *m_item;

    /**
     * The layout of the tool tip.
     */
    TQGridLayout *m_layout;

    /**
     * This function sets up the tool tip.
     */
    void setupTip();

    /**
     * Tells us if the tool tip has already been set up.
     */
    bool m_is_set_up;

    /**
     * This label holds the variable value of the free
     * space left on the share.
     */
    TQLabel *m_free;

    /**
     * This label holds the variable value of the used
     * space on the share.
     */
    TQLabel *m_used;

    /**
     * This label holds the value of the total space
     * available on the share.
     */
    TQLabel *m_total;

    /**
     * This label holds the variable value of the usage
     */
    TQLabel *m_usage;

    /**
     * This label holds the pixmap.
     */
    TQLabel *m_pixmap;
};

#endif
