/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "generic_config.h"

#include "global.h"

#if defined(NO_KDE)
#  include <tqsettings.h>
class GenericConfigPrivate
{
public:
  GenericConfigPrivate(const TQString &group) { _settings.beginGroup("/piklab/" + group); }
  TQSettings _settings;
};
#else
#  include <tdeapplication.h>
#  include <tdeconfig.h>
class GenericConfigPrivate
{
public:
  GenericConfigPrivate(const TQString &group) : _group(group) {}
  ~GenericConfigPrivate() { kapp->config()->sync(); }
  TDEConfig &config() {
    TDEConfig *conf = kapp->config();
    conf->setGroup(_group);
    return *conf;
 }

private:
  TQString _group;
};
#endif

GenericConfig::GenericConfig(const TQString &group)
  : _group(group)
{
  _d = new GenericConfigPrivate(group);
}

GenericConfig::~GenericConfig()
{
  delete _d;
}

void GenericConfig::rollback()
{
#if defined(NO_KDE)
  tqWarning("Config rollback not supported");
#else
  _d->config().rollback();
#endif
}

TQString GenericConfig::readEntry(const TQString &key, const TQString &def) const
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  return _d->_settings.readEntry(key, def);
#  else
  return _d->_settings.value(key, def).toString();
#  endif
#else
  return _d->config().readEntry(key, def);
#endif
}
void GenericConfig::writeEntry(const TQString &key, const TQString &value)
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  _d->_settings.writeEntry(key, value);
#  else
  _d->_settings.setValue(key, value);
#  endif
#else
  _d->config().writeEntry(key, value);
#endif
}

TQStringList GenericConfig::readListEntry(const TQString &key, const TQStringList &defaultValues) const
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  if ( _d->_settings.readEntry(key).isNull() ) return defaultValues;
  return _d->_settings.readListEntry(key);
#  else
  return _d->_settings.value(key, defaultValues).toStringList();
#  endif
#else
  if ( !_d->config().hasKey(key) ) return defaultValues;
  return _d->config().readListEntry(key);
#endif
}
void GenericConfig::writeEntry(const TQString &key, const TQStringList &value)
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  _d->_settings.writeEntry(key, value);
#  else
  _d->_settings.setValue(key, value);
#  endif
#else
  _d->config().writeEntry(key, value);
#endif
}

TQValueList<int> GenericConfig::readIntListEntry(const TQString &key) const
{
#if defined(NO_KDE)
  TQValueList<int> ilist;
  TQStringList list = readListEntry(key, TQStringList());
  TQStringList::const_iterator it;
  for (it=list.begin(); it!=list.end(); ++it) {
    bool ok;
    int v = (*it).toInt(&ok);
    if ( !ok ) return ilist;
    ilist.append(v);
  }
  return ilist;
#else
  return _d->config().readIntListEntry(key);
#endif
}
void GenericConfig::writeEntry(const TQString &key, const TQValueList<int> &value)
{
#if defined(NO_KDE)
  TQStringList list;
  TQValueList<int>::const_iterator it;
  for (it=value.begin(); it!=value.end(); ++it) list.append(TQString::number(*it));
  writeEntry(key, list);
#else
  _d->config().writeEntry(key, value);
#endif
}

TQSize GenericConfig::readSizeEntry(const TQString &key, const TQSize *def) const
{
#if defined(NO_KDE)
  TQValueList<int> list = readIntListEntry(key);
  if ( list.count()!=2 ) return *def;
  return TQSize(list[0], list[1]);
#else
  return _d->config().readSizeEntry(key, def);
#endif
}
void GenericConfig::writeEntry(const TQString &key, const TQSize &value)
{
#if defined(NO_KDE)
  TQValueList<int> ilist;
  ilist.append(value.width());
  ilist.append(value.height());
  writeEntry(key, ilist);
#else
  _d->config().writeEntry(key, value);
#endif
}

bool GenericConfig::readBoolEntry(const TQString &key, bool def) const
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  return _d->_settings.readBoolEntry(key, def);
#  else
  return _d->_settings.value(key, def).toBool();
#  endif
#else
  return _d->config().readBoolEntry(key, def);
#endif
}
void GenericConfig::writeEntry(const TQString &key, bool value)
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  _d->_settings.writeEntry(key, value);
#  else
  _d->_settings.setValue(key, value);
#  endif
#else
  _d->config().writeEntry(key, value);
#endif
}

int GenericConfig::readIntEntry(const TQString &key, int def) const
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  return _d->_settings.readNumEntry(key, def);
#  else
  return _d->_settings.value(key, def).toInt();
#  endif
#else
  return _d->config().readNumEntry(key, def);
#endif
}
void GenericConfig::writeEntry(const TQString &key, int value)
{
#if defined(NO_KDE)
#  if [[[TQT_VERSION IS DEPRECATED]]]<0x040000
  _d->_settings.writeEntry(key, value);
#  else
  _d->_settings.setValue(key, value);
#  endif
#else
  _d->config().writeEntry(key, value);
#endif
}

void GenericConfig::deleteGroup(const TQString &group)
{
#if defined(NO_KDE)
  Q_UNUSED(group);
  // #### cannot do that...
#else
  kapp->config()->deleteGroup(group);
#endif
}

TQVariant GenericConfig::readVariantEntry(const TQString &key, const TQVariant &defValue) const
{
  switch (defValue.type()) {
    case TQVariant::Bool: return TQVariant(readBoolEntry(key, defValue.toBool()), 0);
    case TQVariant::UInt: return readUIntEntry(key, defValue.toUInt());
    default: break;
  }
  Q_ASSERT(false);
  return TQVariant();
}

void GenericConfig::writeEntry(const TQString &key, const TQVariant &v)
{
  switch (v.type()) {
    case TQVariant::Bool: writeEntry(key, v.toBool()); break;
    case TQVariant::UInt: writeEntry(key, v.toUInt()); break;
    default: Q_ASSERT(false); break;
  }
}
