/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

// KDE includes
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <tdemessagebox.h>
#include <tdemainwindow.h>
#include <kapp.h>

#include <tdelocale.h>
#include <dcopclient.h>
#include <tqstring.h>

// App includes
#include "kvpnc.h"
static const char *description =
    I18N_NOOP ( "TDE frontend for various vpn clients\nCurrently supported protocols:\n* Cisco (vpnc (free), vpnclient (propritary))\n* IPSec (FreeS/WAN, Openswan, strongSwan, racoon)\n* PPTP\n* OpenVPN\n* L2TP (l2tpd, xl2tpd, openl2tp) over IPSec (racoon, FreeS/WAN, Openswan, strongSwan)\n* Vtun\n* SSH" );
// TQDate().fromString(, Qt::LocalDate ).toString( "yyyyMMdd" )
TQString date ( __DATE__ );
TQString day= date.section ( ' ',0,0 );
TQString month= TQString().setNum ( TQDate::fromString ( date.section ( ' ',0,0 ),Qt::ISODate ).month() );
TQString year= date.section ( ' ',2,2 );

TQString currentdate ( "+SVN(" + date+" "+ TQTime().fromString ( TQString ( __TIME__ ) ).toString ( "hhmm" ) + ")" );


#define __is_release__

TQString versionstring1 = "0.9.6";

#ifdef __is_release__
static const char *KVPNCVERSION = versionstring1.ascii();
TQString versionstring =TQString ( KVPNCVERSION );
#else
TQString versionstring = versionstring1 + TQString (" KDE3 ") + currentdate;
static const char *KVPNCVERSION  = versionstring.ascii() ;
#endif


static TDECmdLineOptions options[] =
{
	// INSERT YOUR COMMANDLINE OPTIONS HERE
	{ "openvpnimport <file>", I18N_NOOP ( "Import OpenVPN config file" ), 0 },
	{ "ciscoimport <file>", I18N_NOOP ( "Import Cisco PCF file" ), 0 },
	{ ":", I18N_NOOP ( "Extra options:" ), 0 },
	TDECmdLineLastOption // End of options.
};

int main ( int argc, char *argv[] )
{
	TDEAboutData aboutData ( "kvpnc", I18N_NOOP ( "KVpnc" ),
	                       KVPNCVERSION, description, TDEAboutData::License_GPL_V2,
	                       I18N_NOOP ( "(C) 2005, the KVpnc team" ), 0,
	                       "http://home.gna.org/kvpnc/", "crissi99@gmx.de" );

	aboutData.addAuthor ( "Christoph Thielecke", I18N_NOOP ( "Developer and maintainer" ), "crissi99@gmx.de", "http://crissi.linux-administrator.com/" );

	aboutData.setVersion (versionstring.ascii());
	aboutData.setShortDescription (description );

	aboutData.addCredit ( "KDE Team" , I18N_NOOP ( "KDE" ), "", "http://www.kde.org/" );
	aboutData.addCredit ( "KDevelop Team" , I18N_NOOP ( "KDevelop" ), "", "http://www.kdevelop.org/" );
	aboutData.addCredit ( "Maurice Massar" , I18N_NOOP ( "Vpnc" ), "vpnc@unix-ag.uni-kl.de", "http://www.unix-ag.uni-kl.de/~massar/vpnc/" );
	aboutData.addCredit ( "Witek Strzelczyk", I18N_NOOP ( "Polish translation" ), "witek_strzelczyk@go2.pl" );
	aboutData.addCredit ( "Tomas Olah" , I18N_NOOP ( "Slovak translation" ), "tomas.olah@alert.sk" );
	aboutData.addCredit ( "Lapo Luchini" , I18N_NOOP ( "Italian translation" ), "lapo@lapo.it" );
	aboutData.addCredit ( "Karoly Barcza", I18N_NOOP ( "Hungary translation" ), "kbarcza@blackpanther.hu" );
	aboutData.addCredit ( "Luk De Ketelaere" , I18N_NOOP ( "Dutch translation" ), "balboy@kvirc.net" );
	aboutData.addCredit ( "Jorgen Kessler" , I18N_NOOP ( "Dutch translation" ), "jkesseler@home.nl" );
	aboutData.addCredit ( "Atanas M." , I18N_NOOP ( "Bulgarian translation" ), "bugar@developer.bg" );
	aboutData.addCredit ( "Juanjo Avarez Martinez" , I18N_NOOP ( "Spanish translation" ), "juanjux@yahoo.es" );
	aboutData.addCredit ( "He Shi Jun" , I18N_NOOP ( "Chinese translation" ), "hax.sfo@gmail.com" );
	aboutData.addCredit ( "Marius Pacha" , I18N_NOOP ( "Chinese translation" ), "marius@matux.de" );
	aboutData.addCredit ( "Valeriy Girchenko" , I18N_NOOP ( "Russian translation" ), "valeragir@mail.ru" );
	aboutData.addCredit ( "Ahinu" , I18N_NOOP ( "French translation" ), "ahinu@wanadoo.fr" );
	aboutData.addCredit ( "Florian Fainelli" , I18N_NOOP ( "French translation" ), "florian@alphacore.net" );
	aboutData.addCredit ( "Damien Raude-Morvan" , I18N_NOOP ( "French translation" ), "drazib@drazzib.com" );
	aboutData.addCredit ( "Daniel Nylander" , I18N_NOOP ( "Swedish translation" ), "po@danielnylander.se" );
	aboutData.addCredit ( "Yukiko Bando" , I18N_NOOP ( "Japanese translation" ), "ybando@k6.dion.ne.jp" );
	aboutData.addCredit ( "Marc Serra Romero" , I18N_NOOP ( "Catalan translation" ), "mad93@majomo.com" );
	aboutData.addCredit ( "Buelent SENER" , I18N_NOOP ( "Turkish  translation" ), "bsener@inonu.edu.tr" );
	aboutData.addCredit ( "Laurent Montel", I18N_NOOP ( "Patches" ), "montel@kde.org" );
	aboutData.addCredit ( "Peter Kussmann" , I18N_NOOP ( "PPTP-Test environment, OpenVPN testing, new ideas" ), "peter.kussmann@gmx.de" );
	aboutData.addCredit ( "Ansgar Jazdzewski" , I18N_NOOP ( "OpenVPN-Test environment, OpenVPN testing, new ideas" ), "ansgarj@gmx.de" );
	aboutData.addCredit ( "D. Klinkenberg" , I18N_NOOP ( "Testing PPTP, usebility hints & tests, bug hunting" ), "d.klinkenberg@gmx.net" );
	aboutData.addCredit ( "Lenon Kitchens" , I18N_NOOP ( "Testing OpenSWAN, bug hunting" ), "lenon@sanctuary.org" );
	aboutData.addCredit ( "Fathi Boudra" , I18N_NOOP ( "Testing OpenVPN, bug hunting" ), "fboudra@free.fr" );
	aboutData.addCredit ( "HAL9000" , I18N_NOOP ( "Cisco password decoder" ), "hal9000@evilscientists.de" );
	aboutData.addCredit ( "Marcin Prejsnar" , I18N_NOOP ( "Testing OpenVPN auth+cert, bug hunting" ), "alex@pronet.pl" );
	aboutData.addCredit ( "Elias Probst" , I18N_NOOP ( "Icon artwork, bug hunting" )," elias.probst@gmx.de" );
	aboutData.addCredit ( "Andreas Diestelmann" , I18N_NOOP ( "Support KVpnc development with 15EUR" ),"andreas@diestelmann.de" );
	aboutData.addCredit ( "Frank Visconti" , I18N_NOOP ( "Support KVpnc development with 30$" ),"frank3@viscontifamily.net" );
	aboutData.addCredit ( "Christoph Schmid" , I18N_NOOP ( "Support KVpnc development with 30EUR" ),"chris@schlagmichtod.de" );
	aboutData.addCredit ( "Attila Ruzsinszky" , I18N_NOOP ( "Cisco testbed, bug hunting" ), "ruzsinszky.attila@gmail.com" );
	aboutData.addCredit ( "Christiansen" , I18N_NOOP ( "Danish translation" ), "susebruger@mailme.dk" );

	// Initialize command line args
	TDECmdLineArgs::init ( argc, argv, &aboutData);

	// Add options from other components
	TDEApplication::addCmdLineOptions();
	TDECmdLineArgs::addCmdLineOptions ( options );

	TDEApplication a;
	KVpnc *kvpnc =  new KVpnc ( &a );

	DCOPClient* dcop = a.dcopClient();
	dcop->attach();
	dcop->registerAs ( "kvpnc" );
	dcop->setNotifications ( true );

	// Broken on request from Eric M.
	if ( a.isSessionRestored() )
	{
		kvpnc->restore();
	}
	else
	{
// 		if (getenv("USER") != TQString("root"))
// 		{
// 			KMessageBox::error( 0, I18N_NOOP( "Kvpnc must be started as root!" ) );
// 			exit(0);
// 		}

		TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

		a.setMainWidget ( kvpnc );

		if ( args->isSet ( "openvpnimport" ) )
		{
			TQString openvpnimportfile = TQString ( args->getOption ( "openvpnimport" ) );
			kvpnc->importOpenvpnProfileClicked ( openvpnimportfile );
		}
		else if ( args->isSet ( "ciscoimport" ) )
		{
			TQString ciscoimportfile = TQString ( args->getOption ( "ciscoimport" ) );
			kvpnc->importOpenvpnProfileClicked ( ciscoimportfile );
		}

	}
	int ret = a.exec();
	return ret;
}

