#ifndef _KVINOTIFIERWINDOWBORDER_H_
#define _KVINOTIFIERWINDOWBORDER_H_
//=============================================================================
//
//   File : kvinotifierwindowborder.h
//   Created on lun 03 gen 2005 02:27:22 by Iacopo Palazzi
//
//   This file is part of the KVIrc distribution
//   Copyright (C) 2005 Iacopo Palazzi < iakko(at)siena(dot)linux(dot)it >
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "notifiersettings.h"

#include <tqsize.h>
#include <tqrect.h>
#include <tqpixmap.h>

class TQPainter;

class KviNotifierWindowBorder
{
public:
	KviNotifierWindowBorder(TQSize = TQSize(WDG_MIN_WIDTH,WDG_MIN_HEIGHT));
	~KviNotifierWindowBorder();

// ================================
// Put members declaration below...
// ================================
private:
	TQRect 	m_rct;
	TQPoint	m_pnt;

	TQRect	m_closeIconRect;
	
	TQRect	m_captionRect;
	TQRect	m_bodyRect;
	TQRect	m_tabsRect;
	TQRect	m_titleRect;
	
	TQRect	m_progressRect;

	// Pictures
	TQPixmap * m_pixSX;
	TQPixmap * m_pixDX;
	TQPixmap * m_pixDWN;
	TQPixmap * m_pixDWNSX;
	TQPixmap * m_pixDWNDX;
	TQPixmap * m_pixCaptionSX;
	TQPixmap * m_pixCaptionDX;
	TQPixmap * m_pixCaptionBKG;
	TQPixmap * m_pixIconClose_out;
	TQPixmap * m_pixIconClose_over;
	TQPixmap * m_pixIconClose_clicked;
	TQPixmap * m_pixIconClose;
	
	TQPixmap m_pixSX_N;
	TQPixmap m_pixDX_N;
	TQPixmap m_pixDWN_N;
	TQPixmap m_pixDWNSX_N;
	TQPixmap m_pixDWNDX_N;
	TQPixmap m_pixCaptionSX_N;
	TQPixmap m_pixCaptionDX_N;
	TQPixmap m_pixCaptionBKG_N;
	TQPixmap m_pixIconClose_out_N;
	TQPixmap m_pixIconClose_over_N;
	TQPixmap m_pixIconClose_clicked_N;
	
	TQPixmap m_pixSX_HL;
	TQPixmap m_pixDX_HL;
	TQPixmap m_pixDWN_HL;
	TQPixmap m_pixDWNSX_HL;
	TQPixmap m_pixDWNDX_HL;
	TQPixmap m_pixCaptionSX_HL;
	TQPixmap m_pixCaptionDX_HL;
	TQPixmap m_pixCaptionBKG_HL;
	TQPixmap m_pixIconClose_out_HL;
	TQPixmap m_pixIconClose_over_HL;
	TQPixmap m_pixIconClose_clicked_HL;
		
	int m_iTabsHeight;
	int m_iTitleFontHeight;
	int m_eIconState;
	int m_iRctWidth;
	int m_iRctHeight;
	
	bool m_bNeedToRedraw;
	
public:
protected:


// ================================
// Put methods declaration below...
// ================================
private:
	void loadImages();
	void recalculatePositions();

public:
	// reading methods...
	void setWidth(int w);
	void setHeight(int h);
	void resize(int w, int h) { setWidth(w); setHeight(h); };
	void resize(TQSize r) { setWidth(r.width()); setHeight(r.height()); };
	void setGeometry(TQRect r) { r.topLeft(); r.size(); 	/*debug("x,y: %d,%d", r.x(), r.y()); debug("w,h: %d,%d", r.width(), r.height());*/ };
	void setGeometry(TQPoint p, TQSize s) { setPoint (p.x(), p.y()); setWidth (s.width()); setHeight (s.height()); };
										
	void setPoint(int x, int y) { m_pnt.setX(x); m_pnt.setY(y); m_rct.setX(x); m_rct.setY(y);  };
	
	void setCloseIcon(int state);
	void resetIcons();

	// writing methods...	
	int x() { return m_pnt.x(); };
	int y() { return m_pnt.y(); };
	int width() { return m_rct.width(); };
	int height() { return m_rct.height(); };
	int baseLine() { return (y()+height()); };

	TQRect bodyRect() { return m_bodyRect; };
	TQRect tabsRect() { return m_tabsRect; };
	TQRect captionRect() { return m_captionRect; };
	TQRect rect() { return m_rct; };
	TQRect closeRect() { return m_closeIconRect; };
	TQRect titleRect() { return m_titleRect; };
	TQRect progressRect() { return m_progressRect; };
	
	void centerTitle(int h) { m_iTitleFontHeight = h; };
	
	void touch() { m_bNeedToRedraw = true; };
	
	void draw(TQPainter *, bool b = false);
	void setPics(bool b = false);

protected:

};

#endif //!_KVINOTIFIERWINDOWBORDER_H_
