/***************************************************************************
 *   Copyright (C) 2004-2005 by Daniel Clarke                              *
 *   Copyright (C) 2005 by David Saxton                                    *
 *   daniel.jc@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "microbe.h"
#include "pic14.h"

#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tqfile.h>

#include <iostream>
#include <fstream>
using namespace std;

static const char description[] =
    I18N_NOOP("The Microbe Compiler");

static const char version[] = "0.3";

static TDECmdLineOptions options[] =
{
	{ "show-source", I18N_NOOP( "Show source code lines in assembly output"),0},
	{ "nooptimize", I18N_NOOP( "Do not attempt optimization of generated instructions."),0},
	{ "+[Input URL]", I18N_NOOP( "Input filename" ),0},
	{ "+[Output URL]", I18N_NOOP( "Output filename" ),0},
	TDECmdLineLastOption
};

int main(int argc, char **argv)
{
	TDEAboutData about("microbe", I18N_NOOP("Microbe"), version, description,
					 TDEAboutData::License_GPL, "(C) 2004-2005, The KTechlab developers", 0, "http://ktechlab.org", "ktechlab-devel@lists.sourceforge.net" );
	about.addAuthor( "Daniel Clarke", 0, "daniel.jc@gmail.com" );
	about.addAuthor( "David Saxton", 0, "david@bluehaze.org" );
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions( options );
	
	TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
	
	if(args->count() == 2 )
	{
		Microbe mb;	
		TQString s = mb.compile( args->arg(0), args->isSet("show-source"), args->isSet("optimize"));
		TQString errorReport = mb.errorReport();
		
		if ( !errorReport.isEmpty() )
		{
			cerr << mb.errorReport();
			return 1; // If there was an error, don't write the output to file.
		}
		
		else
		{
			ofstream out(args->arg(1));
			out << s;
			return 0;
		}
	}
	else args->usage();
}

