/***************************************************************************
                          kshowmail.h  -  description
                             -------------------
    begin                : Sat May  6 12:13:57 MEST 2000
    copyright            : (C) 2000-2001 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHOWMAIL_H
#define KSHOWMAIL_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE
#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <kuniqueapplication.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdelocale.h>
#include <kstatusbar.h>
#include <krun.h>
#include <kpassdlg.h>
#include <kdebug.h>
#include <kedittoolbar.h>
#include <kcmultidialog.h>


//include files for KShowMail
#include "configlist.h"
#include "alertdialog.h"
#include "showrecord.h"
#include "showlistviewitem.h"
#include "kshowmaildock.h"
#include "kfeedback.h"
#include "types.h"
#include "kshowmailview.h"
#include "kshowmaildoc.h"
#include "serverdialog.h"
#include "filterlog.h"
#include "filterlogview.h"


// forward declaration of the Kshowmail classes
class KshowmailDoc;
class KshowmailView;

using namespace Types;

/**
  * The base class for Kshowmail application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KshowmailView creates your center view, which is connected
  * to the window's Doc object.
  * KShowMailApp reimplements the methods that TDEMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using TDEAccel.
  * @see TDEMainWindow
  * @see TDEApplication
  * @see TDEConfig
  * @see TDEAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class KShowMailApp : public TDEMainWindow
{
  Q_OBJECT

  friend class KshowmailView;
  friend class KshowmailDock;
  friend class UniqueApp;


  private:

    /**
     * The central document of our application. Just contains the view (m_pView).
     */
    KshowmailDoc* m_pDoc;

    /**
     * Contains the account and messages list views.
     */
    KshowmailView *m_pView;

    /**
     * The setup dialog. Created and used by slotSetup().
     */
    KCMultiDialog* SetupDialog;

    /**
     * refresh messages action; connected with slotRefresh()
     */
    TDEAction* m_actionRefresh;

    /**
     * Contains the application and account settings. The account
     * settings are stored in ConfigElem objects.
     */
    ConfigList m_ConfigList;

    /**
     * Message box which will be shown, when new mail has arrived.
     */
    AlertDialog* m_pAlertDialog;

    /**
     * The window into the system tray.
     */
    KShowMailDock* m_pDockWindow;

    /**
     * The refresh timer. Its timeout signal is connected with slotRefresh().
     */
    TQTimer* m_pTimer;

    /**
     * Application state during the run time. Shows what KShowMail is doing :-) .
     */
     Types::State_Type m_state;

     /**
      * Number of seconds until the next refresh
      */
     unsigned long m_nSecondsToGo;

     /**
      * The filter log.
      */
     FilterLog fLog;


  public:
    /**
     * Constructor of KShowMailApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    KShowMailApp();

    /**
     * Destructor
     */
    ~KShowMailApp();

    /**
     * Contains information about KShowMail, including author, license, version etc.
     * This is accessed in main() when calling KShowMailApp::initMenuBar() to create the help menu.
     */
    static TDEAboutData* m_pAbout;

    /**
     * Delays the next refresh for one minute.
     */
    void delayNextRefresh();


  protected:

    /**
     * sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();

    /**
     * sets up the actions.
     */
    void initActions();

    /**
     * initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();

    /**
     * creates the centerwidget of the TDEMainWindow instance and sets it as the view
     */
    void initView();

    /**
     * queryClose is called by TDEMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask
     * if the document should be saved if Modified; on cancel the closeEvent is rejected.
     * @see TDEMainWindow#queryClose
     * @see TDEMainWindow#closeEvent
     */
    virtual bool queryClose();

    /**
     * queryExit is called by TDEMainWindow when the last window of the app is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of
     * the last window's properties.
     * @see TDEMainWindow#queryExit
     * @see TDEMainWindow#closeEvent
     */
    virtual bool queryExit();

    /**
     * overwrite method of TQObject; will be invoked by the internal TQObject-Timer
     * the timer is set to 1 second in the construtor;
     * this method sets the time to the next refresh in the statusbar and
     * animates the "?" in the traybar, when the refresh is working
     */
    virtual void timerEvent( TQTimerEvent * );

    /**
     * overwrite method of TQWidget;
     * to hide the taskbar button
     */
    virtual bool event(TQEvent *e);

    /**
     * Starts the first refresh or starts the refresh timer
     * with the configured init time.
     */
    void initFirstRefresh();

    /**
     * Stops the refresh timer.
     */
    void stopRefreshTimer();

    /**
     * Starts the refresh timer for the next refresh.
     */
    void initNextRefresh();

    /**
     * Refreshes the status bar filter field.
     */
    void refreshFilterStatusBar();

  protected slots:

    /**
     * Changes the status message of the whole statusbar for two seconds,
     * then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar
     * icons and menu entries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const TQString &text);

    /**
     * Changes the contents in the left status bar item permanently,
     * used to indicate current actions. And sets the current time
     * in the right item.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const TQString &text);

    /**
     * Connected with the setup dialog.
     * Reloads the configuration, if it was changed from the dialog.
     */
    void slotConfChanged();

    /**
     * Connected with action m_actionDelete.
     * Deletes all selected mails.
     */
    void slotDelete();

    /**
     * Connected with signal sigDeleteReady of m_ConfigList.
     * This signal will be emitted when one or many accounts have
     * ended a deletion.
     * This slot refreshes the view, sets the state to idle and sets
     * a normal cursor.
     */
    void slotDeletionReady();

    /**
     * Connected with action m_actionShowMessage.
     * Shows all selected mails.
     */
    void slotShowMessage();

    /**
     * Connected with signal sigShowBodiesReady of m_ConfigList.
     * This signal will be emitted when all accounts have downloaded
     * and shown the selected messages.
     * This slot sets the state to idle and sets a normal cursor.
     */
    void slotShowMessageReady();

    /**
     * Connected with signal sigMessageWindowOpened of m_ConfigList.
     * This signal will be emitted when a window to show a mail body
     * was opened.
     * Switches the cursor to normal view.
     */
    void slotNormalCursor();

    /**
     * Connected with signal sigAllMessageWindowsClosed of m_ConfigList.
     * This signal will be emitted when all windows to show a mail body
     * have been closed.
     * Switches the cursor to waiting view.
     */
    void slotWaitingCursor();

    /**
     * Connected with m_actionRefresh.
     * Refreshes the mail list.
     */
    void slotRefresh();

    /**
     * Connected with signal sigRefreshReady of m_ConfigList.
     * This signal will be emitted when all accounts have refreshed
     * their mail list.
     * This slot refreshes the mail view.
     */
    void slotRefreshReady();

    /**
     * Connected with signal destroyed of the alert message dialog.
     * Sets m_pAlertDialog to NULL, if the dialog was destroyed.
     * If m_pAlertDialog == NULL, slotRefreshReady will create a new instance of it.
     * @see m_pAlertDialog
     * @see slotRefreshReady()
     */
    void slotAlertDestroyed();

    /**
     * Connected with signal signalOk of the alert message dialog.
     * Switches the main window to normal view.
     * @see m_pAlertDialog;
     */
    void slotAlertOk ();

    /**
     * Refreshes the account and messages list view.
     */
    void slotRefreshView ();

    /**
     * If the application state is not "idle" it will stop all current running POP3 jobs.
     * Connected with m_actionStop().
     */
    void slotStop ();

    /**
     * Shows the headers of all selected mails.
     * Connected with action m_actionShowHeader.
     */
    void slotShowHeader();

    /**
     * Connected with standard action configureToolbars.
     * Opens a dialog to configure the icons of the toolbar.
     */
    void slotEditToolbars();

    /**
     * Saves GUI options, account and filter settings to the configuration file.
     */
    void slotSaveOptions();

    /**
     * Calls the close() method of KShowMailApp to exit the application. Uses askCloseConfirmation() to ask
     * the user (if configured). Sets m_bForceClose to TRUE, therefore queryClose() will be passed without
     * anything to do. After that in queryExit() slotSaveOptions() will be invoked.
     */
    void slotFileQuit();

    /**
     * Opens the setup dialog for the highlighted account. Connected with m_actionSetupAccount.
     */
    void slotSetupAccount();

    /**
     * Connected with the standard setup action.
     * If the application state is "idle" (m_state == idle) it will open the configuration dialog.
     */
    void slotSetup();

    /**
     * Shows the filter log.
     */
    void slotShowFilterLog();

    /**
     * Adds the sender of the selected mails to the whitelist
     */
    void slotAddToWhitelist();

    /**
     * Adds the sender of the selected mails to the blacklist
     */
    void slotAddToBlacklist();

    void slotAccountActivated(TQListViewItem*);
    void slotSendFeedbackMail();
    void slotForceClose();




private:

    bool m_bForceClose;


  protected:
    void addFeatureList(KFeedbackQuestion * question);
    bool askCloseConfirmation();

};

#endif // KSHOWMAIL_H
