//
// C++ Implementation: encryption
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "encryption.h"

//used in crypt() and decrypt()
static const char scramble1 [50] = "C6FDC7A1EDFBB6FEE3DBF5BEBAEFDDF7ABC6FDC7A1EDFBB6";
static const char hexstr [17] = "0123456789ABCDEF";

int Encryption::hexbyt( const char c )
{
  if( c >= '0' && c <= '9' )
    return c - '0';
  else
    return c - 'A' + 10;
}

const TQString Encryption::crypt( const KURL& url )
{
  char result[50];
  char scramble2[50];
  TQString hexresult;

  memset (result, 0, 50);
  memset (scramble2, 0, 50);
  int pos = url.pass().length () + 1;
  unsigned int free = 50 - pos;

  if( url.user().length() <= free )
  {
    strcpy( &scramble2[pos], url.user() );
    pos += url.user().length();
    free -= url.user().length();
  }
  else
  {
    memcpy( &scramble2[pos], url.user().latin1(), free );
    free = 0;
  }

  if( url.host().length() <= free )
  {
    strcpy( &scramble2[pos], url.host() );
    pos += url.host().length();
    free -= url.host().length();
  }
  else
  {
    memcpy( &scramble2[pos], url.host().latin1(), free );
    free = 0;
  }

  memcpy( result, url.pass().latin1(), url.pass().length() );
  for (int i = 0; i <= 31; i++)
  {
    result[i] = (char)( result[i] ^ ( scramble1[i] ^ scramble2[i] ) );
    hexresult += hexstr[ result[i] / 16 ];
    hexresult += hexstr[ result[i] % 16 ];
  }

  return hexresult;
}

const TQString Encryption::decrypt( const TQString& pass )
{
  char result[50];

  memset( result, 0, 50 );
  int i;
  for( i = 0; i <= 31; i++ )
  {
    result[i] = (char)hexbyt( pass[ i * 2 ] ) * 16 + hexbyt( pass[ i * 2 + 1 ] );
    result[i] = (char)( result[i] ^ scramble1[i] );
  }

  return result;
}
