/***************************************************************************
 *
 * Copyright (C) 2005 Elad Lahav (elad_lahav@users.sourceforge.net)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#include <ntqtextedit.h>
#include <ntqpushbutton.h>
#include "cscopemsgdlg.h"

/**
 * Class constructor.
 * @param	pParent	The parent widget
 * @param	szName	The widget's name
 */
CscopeMsgDlg::CscopeMsgDlg(TQWidget* pParent, const char* szName)
	: CscopeMsgLayout(pParent, szName, false, 0)
{
	// Hide the dialog when the "Hide" button is clicked
	connect(m_pHideButton, SIGNAL(clicked()), this, SLOT(hide()));
	
	// Clear all messages when the "Clear" button is clicked
	connect(m_pClearButton, SIGNAL(clicked()), m_pMsgText, SLOT(clear()));
}

/**
 * Class destructor.
 */
CscopeMsgDlg::~CscopeMsgDlg()
{
}

/**
 * Appends a given message to the text box.
 * After a new messsage is added, the dialog becomes visible.
 * @param	sText	The text of the message to add
 */
void CscopeMsgDlg::addText(const TQString& sText)
{
	m_pMsgText->append(sText);
	show();
}

#include "cscopemsgdlg.moc"

