/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef PREPMETHODSDIALOG_H
#define PREPMETHODSDIALOG_H

#include <ntqwidget.h>
#include <ntqpushbutton.h>
#include <ntqhbox.h>
#include <ntqlayout.h>
#include <kiconloader.h>
#include <tdelistview.h>

#include "widgets/dblistviewbase.h"

class RecipeDB;
class StdPrepMethodListView;

/**
@author Unai Garro
*/

class PrepMethodsDialog: public TQWidget
{

	Q_OBJECT

public:

	PrepMethodsDialog( TQWidget* parent, RecipeDB *db );
	~PrepMethodsDialog();
	void reload( ReloadFlags flag = Load );
private:
	// Internal data
	RecipeDB *database;
	//Widgets
	TQGridLayout *layout;
	StdPrepMethodListView *prepMethodListView;
	TQHBox *buttonBar;
	TQPushButton *newPrepMethodButton;
	TQPushButton *removePrepMethodButton;
	TDEIconLoader *il;
};
#endif
