/***************************************************************************
 *   Copyright (C) 2005 by Mark Six                                        *
 *   marksix@xs4all.nl                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef _KPICOSIM_H_
#define _KPICOSIM_H_

#include "codeeditor.h"
#include "ksimulator.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdemainwindow.h>
#include <tdelistview.h>
#include <tqsplitter.h>
#include <tdepopupmenu.h>
#include <tdetoolbar.h>
#include <tqtabwidget.h>
#include "kprocessorview.h"
#include "kserialview.h"
#include "kscratchpadview.h"
#include "kportview.h"

class KPicoSim : public TDEMainWindow
{
    Q_OBJECT
  
	public:
	    KPicoSim();
	    virtual ~KPicoSim();
		
	protected:
		CodeEditor * m_editor ;
		TDEListView * m_messages ;		
		TQSplitter * m_splitter ;
		TDEProcessorView * m_processorView ;
		KSerialView *m_serialView ;
		KScratchpadView *m_scratchpadView ;
		TQTabWidget *m_tabWidget ;
		
		TDEPopupMenu * m_fileMenu, * m_debugMenu, * m_settingsMenu, * m_editMenu, * m_peripheralMenu, *m_jtagMenu, *m_helpMenu ;
		
		KSimulator * m_simulator ;
		
		// Export to VHDL
		TQString m_templateFile, m_outputDir, m_entityName ;
	
		bool m_simulationMode ;
		unsigned int m_nrInstructions ;
				
		void appendMessage( TQString str ) ;
		void updateViews() ;
		void updateScratchpadView() ;
		
		virtual void closeEvent( TQCloseEvent *e ) ;
		
		void buildMenu() ;

		void openGUI() ;
		void closeGUI() ;

//		TQPtrList<KPortView> m_ioList ;
		TQString m_bitfile ;

		TQPixmap  m_runPxp, m_stopPxp ;
		TDEToolBar *m_debugBar ;
				
	signals:
		void run() ;
		void stop() ;
	
	public slots:
		void startSim() ;
		void startStop() ;
		void stepped( unsigned int line ) ;
		void messageListClicked( TQListViewItem * item ) ;
		
		void updateProcessorRegs() ;
		void updateProcessorFlags() ;
		
		void newIOPort() ;
		void showSerialPort() ;
		void showScratchpad() ;
		void slotClose() ;

		/* The export functions */
		void fileExportVHDL() ;
		void fileExportCOE() ;
		void fileExportMEM() ;
		void fileExportHEX() ;

		bool compile() ;
		void slotFileNew() ;

//		void removeIOPort( KPortView* ioport ) ;

		/* JTAG */
		void jtagDownload() ;
};

#endif // _KPICOSIM_H_
